#!/usr/bin/awk -f 
# script for computing round-trip time in replica exchange
# syntax :
#        rt.awk -v nrep=n PAR*/energy-file
#          where energy-file  is the REM scaled energy files.
# 
BEGIN{
    start=0;
    told=0
    if(ARGC==1) {
	print " script for computing round-trip time in replica exchange"
	print " syntax :"
	print "        rt.awk -v nrep=n PAR*/energy-file"
	print "          where energy-file  is the REM scaled energy files."
	exit
    }
}
{
    dt=$1-told
    told=$1
    if(nrep==0) {
	nrep=8
    }
    if($NF==1) {
	start=1;
    }
    if ($NF==nrep && start==1) {
	rt++;
        start=0
       }
}
END{
    if(ARGC==1){exit}
    if(rt>0) {
	printf "Round-trip time=%10.2f  round-trips =%5d\n", dt*NR/rt/1000,rt
    }
    else {
	print "no round-trip detected"
    }
}
