#!/usr/bin/awk -f
# script for computing the flux in replica exchange
# syntax :
#        replica_flux.awk -v nrep=n PAR*/energy-file
#        where energy-file  is the REM scaled energy files.
#        nrep is the number of NODES or STATES
#        
BEGIN{
    for(i=2; i<=nrep-1; i++) {
	start[i]=1
	end[i]=0
    }
    NFOLD=1
    for(i=1; i<=nrep; i++) {up[i]=0; down[i]=0; ntu[i]=0; ntd[i]=0}
    if(ARGC==1) {
	print " script for computing the flux in replica exchange ( 10.1103/PhysRevE.78.061905 )"
	print " syntax :"
	print "        replica_flux.awk -v nrep=n PAR*/energy-file"
	print "        where energy-file  is the REM scaled energy files."
	print "        nrep is the number of NODES or STATES"
	exit
    }
}
{
    if($NF==1) {
	for(i=2; i<=nrep-1; i++) {
	    start[i]=1
	    end[i]=0
	}
    }
    if($NF==nrep) {
	for(i=2; i<=nrep-1; i++) {
	    start[i]=0
	    end[i]=1
	}
    }
#   print "rec="NR,"   start="start[$NF] "   end=" end[$NF] " rep="$NF " repold="NFOLD
    for(i=2; i<=nrep-1; i++) {
	if(start[i]==1 && NFOLD<$NF) {ntu[i]++}
	if(end[i]==1 && NFOLD>$NF) {ntd[i]++}
	if($NF==i && start[i]==1 && NFOLD<$NF) {
	    time_up[i]+=ntu[i] 
	    time_up2[i]+=ntu[i]^2
#	    print " UP irep="i " ntu[i]="ntu[i] "  time_up[i]="time_up[i]
	    up[i]++
#	    if(i==3) print "u", NR,i,ntu[i],up[i]
	    ntu[i]=0
 	    start[i]=0
	}
	if($NF==i && end[i]==1 && NFOLD>$NF) {
	    time_down[i]+=ntd[i]
	    time_down2[i]+=ntd[i]^2
#	    print "DN irep="i " ntd[i]="ntd[i] "  time_down[i]="time_down[i]
	    down[i]++
	    ntd[i]=0
#	    if(i==2) print "d", NR,i,ntd[i],down[i]
 	    end[i]=0
	}
#	printf "%3d%8d%8d%3d%3d\n",  i,nup[i],ndown[i],start,end
    }
    NFOLD=$NF
}
ENDFILE {
    for(i=2; i<=nrep-1; i++) {
	start[i]=1
	end[i]=0
    }
    NFOLD=1
}
END{
    if(ARGC==1) {exit}
    nstar=2
    print "#Rep        t_up      dt_up""  ---""     t_down    dt_down"
    for(i=2; i<=nrep-1; i++)
    {
	tu[i]=NR/nrep
	td[i]=NR/nrep
	if(up[i]>0) {
	    tu[i]=time_up[i]/up[i]
	    dtu[i]=sqrt(time_up2[i]/up[i] - tu[i]^2)
	}
	if(down[i]>0) {
	    td[i]=time_down[i]/down[i]
	    dtd[i]=sqrt(time_down2[i]/down[i] - td[i]^2)
	}
	printf "%3d --  %10.3f%10.3f --- %10.3f%10.3f\n",  i, tu[i],dtu[i],td[i],dtd[i]
	if (dtu[i]<=dtd[i]) {
	    nstar=i
	}
    }
    for(i=2; i<=nrep-1; i++)  {
	hu[i]=0
	for(j=2; j<=i-1; j++) {
	    hu[i]+=tu[j]/(j*(j-1))
	}
	hu[i]+=tu[i]/(i-1)
#	print "hu", i,hu[i]
    }
    for(i=2; i<=nrep-1; i++)  {
	hd[i]=0
	for(j=2; j<=nrep-i-1; j++) {
	    hd[i]+=td[nrep-j+1]/(j*(j-1))
	}
	hd[i]+=td[i]/(nrep-i)
#	print "hd", i, hd[i],nstar
    }
    print "# Rep   ftp      theor     hu        hd         nstar" 
    printf "%21s\n", "    1       1       1  "
    for(i=2; i<=nrep-1; i++)  {
	if(i <= nstar) {
	    flux[i]=1-hu[i]/(hu[nstar]+hd[nstar])
	}
	else {
	    flux[i]=hd[i]/(hu[nstar]+hd[nstar])
	}
	printf "%5d %8.2f %8.2f %8.2f %8.2f %10d\n", i,flux[i], nrep/(nrep-1) - i/(nrep-1),hu[i],hd[i],nstar
    }
    printf "%5d%16s\n", nrep, "     0       0"
}
