#!/bin/bash
# This script evaluates the mean curtosis and skewness from data using
# bootstrap.  
if [ $# -eq 0 ];  then
    echo ""
    echo " This script evaluates the mean curtosis and skewness from work data using bootstrap.  "
    echo "     Syntax: kurt+skew.bash workfile " 
    exit
fi

if [ ! -f $1 ]; then
    echo "file "$1 " not found" 
    exit 
fi

rm tmp  >& /dev/null
#    echo "Doing" $i; 
for j in  {1..50}  ; do 
        bs_res.awk -v seed=$j $1  > tmp.0 ; free.awk tmp.0  >> tmp  ;
done 
# error interval corresponds to 95% confidence interval (2*sigma) 
awk -v fn=$1 '{m+=$1; m2+=$1^2; s+=$2; s2+=$2^2; a+=$3; a2+=$3^2;  b+=$4; b2+=$4^2} END {printf "%9s%9.3f%9.3f%9.3f%9.3f%9.3f%9.3f%9.3f%9.3f\n", fn,m/NR,2*sqrt(m2/NR-(m/NR)^2),s/NR,2*sqrt(s2/NR-(s/NR)^2),a/NR,2*sqrt(a2/NR-(a/NR)^2),b/NR,2*sqrt(b2/NR-(b/NR)^2)}' tmp 

rm tmp* >& /dev/null
