#!/usr/bin/awk -f
# estimate the height (with respect to the MAX) of the crossing point of
# two CT-related gaussian distributions
# it is easy to see that the height of the gaussian at the
# crossing point (relative to the maximum) is given by
# h(sigma) = exp(-beta^2*sigma^2/2) 
# syntax 
# usage height_crossing_gauss -v x=sigma /dev/null

BEGIN {
    if(ARGC==1){
	print " "
	print " Make an estimate the height (with respect to the MAX) of the crossing point of"
	print " two CT-related gaussian distributions"
	print " it is easy to see that the height of the gaussian at the"
	print " crossing point (relative to the maximum) is given by"
	print " h(sigma) = exp(-beta^2*sigma^2/2) "
	print " "
	print " Syntax "
	print " usage height_crossing_gauss -v x=sigma /dev/null"
	exit
    }
    print exp(-0.6^2*x^2/2)
}
