#! /usr/bin/awk -f
# generate a Gaussianly distribited work sample
#
# syntax ./gen_gauss_work.awk [ -v n=n -v sig=sig -v wm=wm -v seed=seed] /dev/null
#         where:
#                n   -> the number of points in the sample
#                sig -> the half-width of the gaussian distribution (in kcal/mol) 
#                wm  -> is the mean of the gaussian distribution (in kcal/mol) 
#                seed ->is the initial random seed
#
#  The output is in kj mole  so that it can be processed by em (ExpMaxim)  
#
# Example of usage:
#
#     to generate a sample made of a major (0.9) and minor (c=0.1) Gaussian component just do
#  $ ./gen_gauss_work.awk -v n=10000 -v sig=2.0 -v seed=2 -v wm=10 /dev/null > file.wrk
#  $ ./gen_gauss_work.awk -v n=1000  -v sig=3.0 -v seed=2 -v wm=5  /dev/null >>file.wrk
#
# written by P.Procacci (unifi 2021) 
BEGIN {
    srand(seed)
# se default width, mean ( in kcal/mol) and size of the Gussian sample
    if(sig==0) {sig = 1}
    if(wm==0) { wm = 0.0 }
    if (n==0)  {n = 1000 }
    # transform to kJ 
    sig2=sig*sig*(4.184)^2; 
    wm = wm*4.184
    if(ARGC==1) {
	print " generate a Gaussianly distribited work sample"
        print " " 
	print " Syntax ./gen_gauss_work.awk [ -v n=n -v sig=sig -v wm=wm -v seed=seed] /dev/null"
	print "         where:"
	print "                n   -> the number of points in the sample"
	print "                sig -> the half-width of the gaussian distribution (in kcal/mol) "
	print "                wm  -> is the mean of the gaussian distribution (in kcal/mol) "
	print "                seed ->is the initial random seed"
	print ""
	print "  The output is in kj mole  so that it can be processed by em (ExpMaxim)  "
	print ""
	print " Example of usage:"
	print ""
	print "     to generate a sample made of a major (0.9) and minor (c=0.1) Gaussian component just do"
	print "  $ ./gen_gauss_work.awk -v n=10000 -v sig=2.0 -v seed=2 -v wm=10 /dev/null > file.wrk"
	print "  $ ./gen_gauss_work.awk -v n=1000  -v sig=3.0 -v seed=2 -v wm=5  /dev/null >>file.wrk"
	exit;
    }
}
END{
    if(ARGC==1) {exit}
    for(i=1; i<=n; i++) {
	w=sqrt(-2*sig2*log(rand()))*cos(2*3.14*rand()) + wm
	printf "%10.5f\n",  w
    }
}
