#! /usr/bin/awk -f
BEGIN{
    beta=1.0/0.596128; 
    kcal =1./4.184; wmin = 1E20
    if(ARGC==1) {
	print "compute mean, sigma, skewness, kurtosis and free energies from a work file (in kj/mol); output is given in kcal/mol "
	print ""
	print "First six fields in output are:"
	print " 1:<W>  2:sigma^2  3:Skew  4:Kurt  5:DG(gauss)  6:DG(Jarz)"
	exit
    }
}
{
    wt=kcal*$1; wtj[NR]=wt; 
    w+=wt; w2+=wt^2; w3+=wt^3; w4+=wt^4;
    if(wt < wmin) {wmin=wt}
} 
END {
#   To avoid overflow jarzynski average is computed as 
#   following:
#   DG = -kT log (sum_i e^-bW_i /N)
#      = -kT log [e^-bWmin(\sum_i e^b_(W_i-Wmin)/N]
#      =  Wmin -kT log(\sum_i e^b_(W_i-Wmin)/N]
#      = Wmin + kT (log N - log(\sum_i e^b_(W_i-Wmin))   
#   computes jarzynski correction 
    if(ARGC==1) {exit}
    jarz1=0
    for(i=1; i<=NR; i++) {
	dwi = wtj[i]-wmin;
	jarz1+=exp(-beta*dwi)
    }
    jarz=wmin +(1./beta)*(log(NR) -log(jarz1)) 
    wm= w/NR; w2m=w2/NR; w3m=w3/NR; w4m=w4/NR; 
    sig= w2m-wm^2; 
    skew=w3m-3*w2m*wm + 2*wm^3
    kurt=w4m-4*w3m*wm+6*w2m*wm^2-3*wm^4
    skew=skew/sig^(1.5)
    kurt = kurt/sig^2 - 3
    print wm,sig,skew,kurt,wm-0.5*beta*sig,jarz, "(wmin=",wmin,")", " JB-test = ",NR*((skew)^2./6 + (kurt)^2/24) ,NR
}
