#!/usr/bin/awk -f
BEGIN {
    for(i=2; i<=nrep-1; i++) {
	start[i]=1
	end[i]=0
    }
    NFOLD=1
    for(i=1; i<=nrep; i++) {
	   zd[i]=0
	   zu[i]=0
       }

    if(ARGC==1) {
	print " script for computing the flux in replica exchange ( 10.1103/PhysRevE.78.061905 )"
	print " syntax :"
	print "        replica_flux.awk -v nrep=n PAR*/energy-file"
	print "        where energy-file  is the REM scaled energy files."
	print "        nrep is the number of NODES or STATES"
	exit
    }
}
{
    if($NF==1) {
	for(i=2; i<=nrep-1; i++) {
	    start[i]=1
	    end[i]=0
	}
    }
    if($NF==nrep) {
	for(i=2; i<=nrep-1; i++) {
	    start[i]=0
	    end[i]=1
	}
    }
#    print "NR="NR "  REP="$NF " REP_old="NFOLD "  start[REP]="start[$NF]
    for(i=2; i<=nrep-1; i++)  {
	   if($NF==i && start[i]==1 && NFOLD<$NF) {
	       zu[i]++
#	       print "I="i "  REP="$NF "  REP_old" NFOLD "  ZU =" zu[i]
	       start[i]=0
	   }
	   if($NF==i && end[i]==1 && NFOLD>$NF) {
		 zd[i]++
		 end[i]=0
	     }	     
       }
    NFOLD=$NF
}
ENDFILE { 
        for(i=2; i<=nrep-1; i++) {
	start[i]=1
	end[i]=0
    }
    NFOLD=1
}
END {
    print "# Rep   ftp     theor      nu      nd    " 
    printf "%21s\n", "    1       1       1  "
    for(i=2; i<=nrep-1; i++)  {
	a=zu[i]+ zd[i]
	if (a>0) {
	    printf "%5d%8.3f%8.3f%8d%8d\n",  i, zu[i]/a, nrep/(nrep-1) - i/(nrep-1), zu[i],zd[i]
	}
	else {
	    printf "%5d%8.3f%8.3f%8d%8d\n",  i, zu[i]/a, nrep/(nrep-1) - i/(nrep-1) , zu[i],zd[i]
	}
    }
    printf "%5d%16s\n", nrep, "     0       0"
}
