#!/bin/bash

if [ -z $1 ] || [ -z $2 ] ; then
    echo "syntax:"
    echo "  find_bias.bash SIGMA N "
    echo "        where: "
    echo "         SIGMA is the standard deviation (sqrt of variance)"
    echo "         N is the number of points of the sample"
    exit 
fi

( for i in {1..100} ; do
      gen_gauss_work.awk -v n=$2 -v sig=$1 -v seed=$i -v wm=50 /dev/null > file.wrk ;
      free.awk file.wrk ;
  done ) | awk '{printf "%7.1f%7.1f%7.1f\n",  $5,$6, $6-$5}' | awk '{a+=$3}END{print a/NR}'

