#! /usr/bin/awk -f
BEGIN{
    start=0
    i=0
    if(ARGC==1) {
	print" "
	print "Compute the drift from an orac energy file (mts_test) (NTP)"
	print "Syntax: drift.awk [ -v r=1 ] energy_file"
	print "    r=1 is specified if an equilibration part is to be skipped " 
	print" "
	exit;
    }
    if(r!=1) {
	start=1  # no restart; start immediately     
    }
}
	
{
    # read first record if no restart
    if (start==1 && NR==2) {
	E0=$3; EE[i]=0.0
    }
    # file contain an equilibration part. Read starting record at time 0.0
    if ( r == 1 && $1 != "#" &&  $1 == "time" && NR>1 && $2==0) {
	start=1 
	E0=$3; EE[i]=0.0
    }
    if (start==1 && $1 != "#") {
	i++; e=$3; k+=$7; k2+=$7^2; em+=$3; em2+=$3^2 
	EE[i] = e-E0; 
	tt[i] = $2;
	xy+=$2*$3
	x+=$2; y+=$3; 
	x2+=$2^2; y2+=$3^2; 
    } 
}
END{ 
    if(ARGC==1) {exit}
    drift_fs=(i*xy-x*y)/(i*x2-x*x)
    for (j=1; j<=i; j++) {
	edepur=EE[j]-drift_fs*tt[j]
	e2+=edepur^2;
	print tt[j],EE[j], edepur, drift_fs*tt[j]
    }
    km=k/i
    em=em/i
    dem=sqrt(em2/i-em^2)
    de=sqrt(e2/i); dd=1000000*drift_fs
    dk=sqrt(k2/i - (k/i)^2) ;
#    print dem,dk,em,km 
    ratio= sqrt((dd/de)^2) ;
    ratio2 = dem/dk
    printf "# Drift (KJ/ns)%10.4f%10.5f%10.4f%10.4f\n",1000000*drift_fs,de,ratio,ratio2
}
