#!/bin/bash
#
#  reconstruct the a pdb trajectories from a set of restart files 
#  as dumped using the command save_all_restart
#
#  syntax: 
#  do_pdb.bash tpgprm_file REST_DIR
#  where REST_DIR is the name of the restart files directory 
#  and tpgprm_file is the tpgprm binary file for potential setup

if [ $# == "0" ] ; then
    echo " "
    echo "This code reconstructs a pdb trajectory file from a set of ORAC-generated restart files  "
    echo "  Syntax: do_pdb.bash tpgprm_file REST_DIR"
    echo " "
    exit 
fi
rm $2.pdb >& /dev/null
tdir=`which orac | sed "s?bin/orac?tools/templates?g"`

sed "s/tpgprmfile/$1/g" $tdir/rest2pdb.in > tmp.in  
for i in $2/*.rst; do
    echo $i
    cp $i tmp.rst 
    orac < tmp.in  > /dev/null
    cat tmp.pdb >> $2.pdb  
done    


