#!/usr/bin/awk -f 
BEGIN{
    if(ARGC==1) {
	print " Compute ligand-receptor Centriod-centroid distance from an pdb file"
	print ""
	print " Syntax is:"  
        print " centroid_dist_pdb.awk -v skip=n filename.pdb"
        print "    where skip [optional] is the number of frames to skipped (default is 0) "
	exit
    }
}
{   
    if($1=="ATOM" || $1="HETATM") {
	i++
	if($4== 1) {
	    xl+=$2; yl+=$3; zl+=$4; 
	    ml++
	    
	} else {
	    xh+=$2; yh+=$3; zh+=$4
	    mh++
	}
    }
    if($1 == "REMARK") {
	i=0 ; 
	xl=xl/ml; yl=yl/ml; zl=zl/ml; 
	xh=xh/mh; yh=yh/mh; zh=zh/mh; 
	dx=xl-xh;
	dy=yl-yh;
	dz=zl-zh;
	rcom= sqrt(dx^2+dy^2+dz^2)
#	print $2, rcom, $NF
	if($NF==S || S==0) print  $2, rcom,dx,dy,dz
	xl=0;yl=0;zl=0; ml=0
	xh=0;yh=0;zh=0; mh=0
    }
}

