#! /usr/bin/awk -f
BEGIN{
    icis=0; icys=0; ires=1
    if(ARGC==1) {
	print" "
	print "check for disuplhide bond in PDB file"
	print "Syntax: check_disuplhide.awk PDBfile"
	print" "
	exit;
    }
}
{
    if($3== "CA") {ires++}
    if($4=="CYS" && $3 == "SG") {
	icis++;
	x[icis]=substr($0,31,8);
	y[icis]=substr($0,39,8);
	z[icis]=substr($0,47,8);
	res[icis]=ires
#	print icis,$6,x[icis],y[icis],z[icis],ires,$4
    }
}
END {
    if(ARGC==1) {exit}
    if(icis > 0) {
	print "ADD_TPG  SOLUTE" 
	for(i=1; i<=icis; i++) {
	    for (j=i;j<=icis; j++ ) {
		if(i!=j) {
		    dx=x[i]-x[j]; 
		    dy=y[i]-y[j]; 
		    dz=z[i]-z[j]; 
		    d=sqrt(dx^2+dy^2+dz^2) ;
#		    print i,j,d,res[i],res[j],d
		    if(d<2.5) {
			printf "%23s%5d%5d\n", "bond 1sg 2sg residue ", res[i],res[j]
			icys++
		    }
		}
	    }
	}
	print "END" 
    }
}
