  FUNCTION F(p,nparm) 
    use datafunc
    implicit none 
    include 'omp_lib.h'       ! OMP layer for all platforms but BGQ
    character*4 testname
    character*11 xout_tsk
    character*2 indx
    integer i,j,k,indc,atonum,ipa,ipb,nparm,itask
    logical ok1,ok2
    real*8  p(nparm),f,frange1,aux,aux2

    rewind(12) 
    F=0
    do k=1,np
       ok1=.false.
       ok2=.false.
       do j=1,nparm 
          if(ps(j).eq.pa(k)) THEN 
             ipa=j
             ok1=.true.
          end if
          if(ps(j).eq.pb(k)) THEN 
             ipb=j
             ok2=.true.
          end if
          if(ok1.and.ok2) exit
       end do
       if(typea(k)(1:1).eq."c") atonum=6
       if(typea(k)(1:1).eq."n") atonum=7
       if(typea(k)(1:1).eq."o") atonum=8
       if(typea(k)(1:1).eq."h") atonum=1
       if(typea(k)(1:1).eq."p") atonum=10
       if(typea(k)(1:1).eq."s") atonum=11
       if(typea(k)(1:1).eq."i") atonum=9
       if(typea(k)(1:1).eq."f") atonum=9
       if(typea(k)(1:2).eq."cl") atonum=9
       if(typea(k)(1:2).eq."br") atonum=9
       if(lprint) write(6,300) atonum,typea(k),rvdw(k),p(ipa),p(ipb)
       write(12,300) atonum,typea(k),rvdw(k),p(ipa),p(ipb)
300    format(i3,3x,a3,4x,f10.4,f10.4,f15.6)
    end do
200 continue

    call system("rm calc?? > /dev/null 2>&1 ") 
!$OMP PARALLEL DO SCHEDULE(STATIC) &
!$OMP& SHARED(filein,gexp,namef,calc,string1,string3,string4)  &
!$OMP& PRIVATE (itask,indx,xout_tsk) REDUCTION(+:F)  
    do i=1,nexp 
       itask=1+OMP_GET_THREAD_NUM()
       write(indx,'(i2.2)') i
       xout_tsk=xout//namef(itask)
       call system(orac_call//filein(i)//">"//xout_tsk)  
       call system(string1//xout_tsk//string3//indx//string4//namef(itask))
    end do
!$OMP END PARALLEL DO 
    call system("cat calc?? > calc")
    F=0
    do i=1,nexp 
       read(50,*) indc,calc(indc)  
       F=F+(calc(indc)-gexp(indc))**2.
    end do
    rewind(50)
    frange1=0.d0
    do i=1,np
       aux2 = range/(pup(i)-plo(i))
       aux = 0.0d0 
       if(p(i).gt.pup(i))  aux = (p(i)-pup(i))*aux2 
       if(p(i).lt.plo(i))  aux = (plo(i)-p(i))*aux2
       frange1 = frange1 + aux
    end do

    F=dsqrt(F/float(nexp)) 
!   write(6,*) "func", F,frange1,range
    F=F+frange1
  end FUNCTION F
