!     ----------------------------------------------------------------------
      subroutine rmsd(nn,r,r0,dd,rfit,d)
!     ----------------------------------------------------------------------
!     minimize RMSD through quaternions
!     nn: number of atoms
!     r, r0: cartesian coordinates of the two
!     structures  (r0 will be rotated)
!     dd: minimized rmsd
!     rfit: cartesian coordinates of the rotated r0
!     structure
!     ----------------------------------------------------------------------      
      integer i,j,k,l,nn
      real*8 r(3,nn),r0(3,nn),rr(3),rr0(3),p(3,nn),p0(3,nn),xx
     &     ,yy,zz,x,y,dd,tot(3),tot0(3)
      integer iret, jobn,ier,iopt,ix
      real*8 s,q(0:3),epsi,err
      real*8 lambda(4),wk(nn*nn)
      real*8 rrsq,m(4,4),z(4,4),dm_r(4,4,3),derr_dr(3,nn),d(3,3)
     &     ,rfit(3,nn)
      data epsi /1.0e-10/
      
      iopt = 100
      dd = 0.d0
      
      do j = 1,3
         tot(j)  = 0.d0
         tot0(j) = 0.d0
         do k = 1,nn
            p(j,k)  = r(j,k)
            p0(j,k) = r0(j,k)
            tot(j)  = tot(j)  + r(j,k)
            tot0(j) = tot0(j) + r0(j,k)
         enddo
         tot(j)  = tot(j) / dfloat(nn)
         tot0(j) = tot0(j) / dfloat(nn)
         do k = 1,nn
            p(j,k)  = p(j,k) - tot(j)
            p0(j,k) = p0(j,k) - tot0(j) 
         enddo
      enddo
      
      do i = 1,4
         do j = 1,4
            m(i,j) = 0.d0
         enddo
      enddo
      
      
      do i = 1,nn
         rr(1) = p(1,i)
         rr(2) = p(2,i)
         rr(3) = p(3,i)
         rr0(1)= p0(1,i)
         rr0(2)= p0(2,i)
         rr0(3)= p0(3,i)
         rrsq  = (rr0(1)**2 + rr0(2)**2 + 
     &        rr0(3)**2 + rr(1)**2 + rr(2)**2 + rr(3)**2)
         m(1,1) = m(1,1) + rrsq + 
     &        2.d0* (-rr0(1)*rr(1) - rr0(2)*rr(2) - rr0(3)*rr(3))
         m(2,2) = m(2,2) + rrsq + 
     &        2.d0* (-rr0(1)*rr(1) + rr0(2)*rr(2) + rr0(3)*rr(3))
         m(3,3) = m(3,3) + rrsq + 
     &        2.d0* (+rr0(1)*rr(1) - rr0(2)*rr(2) + rr0(3)*rr(3))
         m(4,4) = m(4,4) + rrsq + 
     &        2.d0* (+rr0(1)*rr(1) + rr0(2)*rr(2) - rr0(3)*rr(3))
         m(1,2) = m(1,2) + 2.d0* (-rr0(2)*rr(3) + rr0(3)*rr(2))
         m(1,3) = m(1,3) + 2.d0* ( rr0(1)*rr(3) - rr0(3)*rr(1))
         m(1,4) = m(1,4) + 2.d0* (-rr0(1)*rr(2) + rr0(2)*rr(1))
         m(2,3) = m(2,3) - 2.d0* ( rr0(1)*rr(2) + rr0(2)*rr(1))
         m(2,4) = m(2,4) - 2.d0* ( rr0(1)*rr(3) + rr0(3)*rr(1))
         m(3,4) = m(3,4) - 2.d0* ( rr0(2)*rr(3) + rr0(3)*rr(2))
      enddo
      m(2,1) = m(1,2)
      m(3,1) = m(1,3)
      m(3,2) = m(2,3)
      m(4,1) = m(1,4)
      m(4,2) = m(2,4)
      m(4,3) = m(3,4)
      
!---- SOLVE THE EIGENVECTOR PROBLEM FOR M: --------------------------*
      
      iret = 0
      jobn   = 12
      call EIGRS(m,4,jobn,lambda,z,4,wk,ier)
      if (ier .ne. 0)      stop ' LSQQTN: Fatal error in eigrs'
      if (wk(1) .gt. 1.d0) iret = 9
!---- PICK THE CORRECT EIGENVECTOR(S): ------------------------------*
      
      s =  1.d0
      if (z(1,1) .lt. 0.d0) s = -1.d0
      q(0) = s*z(1,1)
      q(1) = s*z(2,1)
      q(2) = s*z(3,1)
      q(3) = s*z(4,1)
      if (dabs(lambda(1)) .lt. epsi) then
         err = 0.d0
      else
!     err = dsqrt(lambda(1))
         err = lambda(1)/dfloat(nn)
      endif
      if (dabs(lambda(1) - lambda(2)) .lt. epsi)iret = iret + 10
      
!     if (iret .eq. 0)  write(*,*)
!     &     ' LSQQTN: Normal execution, unique solution'
      if (iret .eq. 10) write(*,*)
     &     ' LSQQTN: Normal execution, non-unique solution'
      if (iret .eq. 9)  write(*,*)
     &     ' LSQQTN: Bad perform. in eigrs, unique solution'
      if (iret .eq. 19) write(*,*)
     &     ' LSQQTN: Bad perform. in eigrs, non-unique solution'
!     if(iret.ne.0)write(6,*)msg
      
      if (iopt .eq. 0) return
      
*---- DERIVATIVES OF RMSD with respect to the positions
      do i = 1,nn
         rr(1) = 2.*p(1,i)
         rr(2) = 2.*p(2,i)
         rr(3) = 2.*p(3,i)
         rr0(1)= 2.*p0(1,i)
         rr0(2)= 2.*p0(2,i)
         rr0(3)= 2.*p0(3,i)
!     
         dm_r (1,1,1) = (rr(1)-rr0(1))
         dm_r (1,1,2) = (rr(2)-rr0(2))
         dm_r (1,1,3) = (rr(3)-rr0(3))
!     
         dm_r (1,2,1) = 0.
         dm_r (1,2,2) =  rr0(3)
         dm_r (1,2,3) = -rr0(2)
!     
         dm_r (1,3,1) = -rr0(3)
         dm_r (1,3,2) =  0.
         dm_r (1,3,3) =  rr0(1)
!     
         dm_r (1,4,1) =  rr0(2)
         dm_r (1,4,2) = -rr0(1)
         dm_r (1,4,3) =  0.
!     
         dm_r (2,2,1) = (rr(1)-rr0(1))
         dm_r (2,2,2) = (rr(2)+rr0(2))
         dm_r (2,2,3) = (rr(3)+rr0(3))
!     
         dm_r (2,3,1) = -rr0(2)
         dm_r (2,3,2) = -rr0(1)
         dm_r (2,3,3) =  0.
!     
         dm_r (2,4,1) = -rr0(3)
         dm_r (2,4,2) =  0.
         dm_r (2,4,3) = -rr0(1)
!     
         dm_r (3,3,1) = (rr(1)+rr0(1))
         dm_r (3,3,2) = (rr(2)-rr0(2))
         dm_r (3,3,3) = (rr(3)+rr0(3))
!     
         dm_r (3,4,1) = 0.
         dm_r (3,4,2) = -rr0(3)
         dm_r (3,4,3) = -rr0(2)
!     
         dm_r (4,4,1) = (rr(1)+rr0(1))
         dm_r (4,4,2) = (rr(2)+rr0(2))
         dm_r (4,4,3) = (rr(3)-rr0(3))
!     
         do ix=1,3
            dm_r(2,1,ix) = dm_r(1,2,ix)
            dm_r(3,1,ix) = dm_r(1,3,ix)
            dm_r(4,1,ix) = dm_r(1,4,ix)
            dm_r(3,2,ix) = dm_r(2,3,ix)
            dm_r(4,2,ix) = dm_r(2,4,ix)
            dm_r(4,3,ix) = dm_r(3,4,ix)
         enddo
!     
         do ix = 1,3
            derr_dr (ix,i) = 0.
            do k = 1,4
               do j = 1,4
                  derr_dr (ix,i) = derr_dr (ix,i) + 
     &                 q(k-1)*q(j-1)*dm_r (j,k,ix)
               enddo
            enddo
            derr_dr (ix,i) = derr_dr (ix,i)/dble(nn)
         enddo 
      enddo
      if (iopt .eq. 1) return
      
*---- ROTATION MATRIX IN TERMS OF QUATERNIONS: ----------------------*
      
      d(1,1) = -2.d0* ( q(2)**2   + q(3)**2) + 1.d0
      d(2,2) = -2.d0* ( q(1)**2   + q(3)**2) + 1.d0
      d(3,3) = -2.d0* ( q(1)**2   + q(2)**2) + 1.d0
      d(1,2) =  2.d0* (-q(0)*q(3) + q(1)*q(2))
      d(1,3) =  2.d0* ( q(0)*q(2) + q(1)*q(3))
      d(2,1) =  2.d0* ( q(0)*q(3) + q(1)*q(2))
      d(2,3) =  2.d0* (-q(0)*q(1) + q(2)*q(3))
      d(3,1) =  2.d0* (-q(0)*q(2) + q(1)*q(3))
      d(3,2) =  2.d0* ( q(0)*q(1) + q(2)*q(3))
      
!     *---- CALCULATE FIT: ------------------------------------------------*
      
      do i = 1,nn
         rfit(1,i) = d(1,1)*p0(1,i) + d(1,2)*p0(2,i) + d(1,3)*p0(3,i)
         rfit(2,i) = d(2,1)*p0(1,i) + d(2,2)*p0(2,i) + d(2,3)*p0(3,i)
         rfit(3,i) = d(3,1)*p0(1,i) + d(3,2)*p0(2,i) + d(3,3)*p0(3,i)
         rfit(1,i) = rfit(1,i) + tot(1)
         rfit(2,i) = rfit(2,i) + tot(2)
         rfit(3,i) = rfit(3,i) + tot(3)
      enddo

      dd = sqrt(err)
      
      return
      end

