subroutine openf(unit_counter,unit_number,file_name,file_status)
  implicit none
  integer, intent(inout) :: unit_counter
  integer, intent(out) :: unit_number
  character*6, intent(in) :: file_name
  character*3, intent(in) :: file_status
  integer :: err
  
  unit_counter = unit_counter + 1

  unit_number = unit_counter
  
  select case(file_status)
  case("OLD")
     open(unit=unit_number,file=file_name,status='OLD',iostat=err)
  case("NEW")
     open(unit=unit_number,file=file_name,status='NEW',iostat=err)
  case("REP")
     open(unit=unit_number,file=file_name,status='REPLACE',iostat=err)
  case("SCR")
     open(unit=unit_number,status='SCRATCH',iostat=err)
  case("UNK")
     open(unit=unit_number,file=file_name,status='UNKNOWN',iostat=err)
  end select

  if(err /= 0) then 
     write(0,*) "error opening unit ", unit_number
     stop
  end if
  
end subroutine openf
