#!/usr/bin/perl

use strict; 
use CGI; 
use CGI::Carp qw ( fatalsToBrowser ); # this is for debigging purposes 
use File::Basename;

$CGI::POST_MAX = 1024 * 50;

my $safe_filename_characters = "a-zA-Z0-9+_.-";

my $upload_dir = ".";

my $query = new CGI; 
my $filename = $query->param("fname"); 
my $opth = $query->param("hydro"); 
my $geom = $query->param("optimize"); 
my $smi = $query->param("smiles"); 

if ( !$filename and !$smi ) { 
    print $query->header ( ); print "No file uploaded: choose a file"; exit; 
}
elsif ( !$filename and $smi ) {
    open(my $fh, '>', 'test.smi');
    print $fh "$smi\n";
    close $fh;
    $filename = "test.smi";
} 
elsif ( $filename  and  $smi ) {
    print $query->header ( ); print "both filename and SMILES code are given; choose one.  "; exit;
}

my ( $name, $path, $extension ) = fileparse ( $filename, '..*' ); 

$filename = $name . $extension;

# strip malicious characters 

$filename =~ tr/ /_/; $filename =~ s/[^$safe_filename_characters]//g;

# match the filename againts unsafe characters

if ( $filename =~ /^([$safe_filename_characters]+)$/ ) { $filename = $1; } else { die "Filename contains invalid characters"; }

# Upload the file 

my $upload_filehandle = $query->upload("fname");

if (!$smi) {open ( UPLOADFILE, ">$upload_dir/$filename" ) or die "$!"; binmode UPLOADFILE; }

while ( <$upload_filehandle> ) { print UPLOADFILE; }
close UPLOADFILE;

# do the actual job here using primadorac_smi.bash
#system " last=`tail -1  $upload_dir/$filename-p.prm`; if [ $last != "END" ]; then echo 'failed'; else mv $filename-p.* tpg-prmf; fi "


# thanking remarks 
print $query->header ( ); print <<END_HTML; 
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "DTD/xhtml1-strict.dtd"> <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en"> 
<head> <meta http-equiv="Content-Type" content="text/html; charset=utf-8" /> 
<title>Thanks!</title> <style type="text/css"> img {border: none;} </style> </head> 
<body> 
<p>Thanks for uploading your file. </p> 
END_HTML

$path = $ENV{'PATH'};       # $path now tainted
delete @ENV{'IFS', 'CDPATH', 'ENV', 'BASH_ENV'};
$path = $ENV{'PATH'};       # $path now not tainted

my $HOME=$ENV{'HOME'};

if($geom eq "no") {
    print " <b> No Optimization </b> <br> ";
    if($opth eq "okh") {
	print "<br> OPTION IS <tt> $opth</tt> $smi $geom : Molecule is correct as is <br> <br> ";
	system("./primadorac_smi.bash -whs $filename  ");
    } elsif ($opth eq "ckh"){
	print "<br> OPTION IS <tt> $opth</tt>: Check for hydrogen atoms only <br>  ";
	print "           No archive will be produced if check fails <br><br> ";
	system("./primadorac_smi.bash -ws $filename  ");
    } elsif ($opth eq "adh") {
	print "<br> OPTION IS <tt> $opth</tt>: hydrogen atoms will be added; total charge will be zero <br> <br> ";
	system("./primadorac_smi.bash -was $filename  ");
    } elsif ($opth eq "adp") {
	print "<br> OPTION IS <tt> $opth</tt>: hydrogen atoms will be added for pH=7 ; <br>  Molecule could be charged <br> <br> ";
	system("./primadorac_smi.bash -wps $filename   ");
    } else {
	print "No selection <br>" ;
    }
} else {
    if($opth eq "okh") {
	print "<br> OPTION IS <tt> $opth</tt>: Molecule is correct as is <br> <br> ";
	system("./primadorac_smi.bash -wh $filename  ");
    } elsif ($opth eq "ckh"){
	print "<br> OPTION IS <tt> $opth</tt>: Check for hydrogen atoms only <br>  ";
	print "           No archive will be produced if check fails <br><br> ";
	system("./primadorac_smi.bash -w $filename  ");
    } elsif ($opth eq "adh") {
	print "<br> OPTION IS <tt> $opth</tt>: hydrogen atoms will be added; total charge will be zero <br> <br> ";
	system("./primadorac_smi.bash -wa $filename  ");
    } elsif ($opth eq "adp") {
	print "<br> OPTION IS <tt> $opth</tt>: hydrogen atoms will be added for pH=7 ; <br>  Molecule could be charged <br> <br> ";
	system("./primadorac_smi.bash -wp $filename  ");
    } else {
	print "No selection <br>" ;
    }
}    
    


