#!/usr/bin/awk -f 
# compute IR spectrum from filenamame-p.frq file 
# to be call on each freq stanza as 
# /ir.awk tmp.esp freqi  
# where tmp.esp are the AM1-BCC charges and freq is is the i-th freq 
#
BEGIN{ 
    mpx=0;mpy=0;mpz=0;
    mmx=0;mmy=0;mmz=0;
}
{    
    if(NR<=n){
	q[NR]=$1; 
    } 
    else if(NR>n+2) {
	i++
	mpx+=($2+$5)*q[i];
	mpy+=($3+$6)*q[i];
	mpz+=($4+$7)*q[i];
	mmx+=($2-$5)*q[i];
	mmy+=($3-$6)*q[i];
	mmz+=($4-$7)*q[i]; 
    }
    else{ 
	if($2=="Frequency") {freq=$4}
    }
}
END{ 
	ir=(0.5*(mpx-mmx))^2
	print freq,ir
}
	
	