#! /usr/bin/awk -f 
    function acos(x) { 
	return atan2(sqrt(1-x*x), x) 
    }

    BEGIN{ 
#       Table 4 of Ref. Gaff Dev 2004 JCC 
	c["h"]=0     ;z["h"]=0.784	   
	c["c"]=1.339 ;z["c"]=1.183	   
	c["n"]=1.300 ;z["n"]=1.212	   
	c["o"]=1.249 ;z["o"]=1.219	   
	c["f"]=0     ;z["f"]=1.166	   
	c["l"]=0     ;z["l"]=1.272	   
	c["b"]=0     ;z["b"]=1.378	   
	c["i"]=0     ;z["i"]=1.398   
	c["l"]=0     ;z["l"]=1.640
	c["p"]=0.906 ;z["p"]=1.620  
	c["s"]=1.448 ;z["s"]=1.280  
    }
{
        if($1=="*ANG") {
	nb++ 
	ib1[nb]=$2;  ib2[nb]=$3;  ib3[nb]=$4;
	tib1[nb]=$6; tib2[nb]=$7; tib3[nb]=$8;
    } 
    if($1=="ATOM" || $1=="HETATM") { 
	na++;
	x[na]=$6; y[na]=$7; z[na]=$8; 
    }	
}
END { 
    print "# "name
    for (i=1; i<=nb; i++) {
	k1=ib1[i]; k2=ib2[i]; k3=ib3[i]; 
	x21=x[k1]-x[k2];y21=y[k1]-y[k2];z21=z[k1]-z[k2];
	x23=x[k3]-x[k2];y23=y[k3]-y[k2];z23=z[k3]-z[k2];
	norm1=sqrt(x21^2+y21^2+z21^2)
	norm2=sqrt(x23^2+y23^2+z23^2)
	ang = acos((x21*x23+y21*y23+z21*z23)/norm1/norm2)
	if(tib1[i]=="cl") {t1="l"} else {t1=substr(tib1[i],1,1)}
	if(tib2[i]=="cl") {t2="l"} else {t2=substr(tib2[i],1,1)}
	if(tib3[i]=="cl") {t3="l"} else {t3=substr(tib3[i],1,1)}
	EDD= exp(-2*((norm1-norm2)/(norm1+norm2))^2 )
#       implement Eq. 5 of Gaff devel JCC 2004
	kb=2.7*EDD*143.9*z[t1]*c[t2]*z[t3]/(norm1 +norm2)/ang^2
	printed=0
	for(j=1; j<i; j++) {
	    if( (tib1[j]==tib1[i] && tib2[j]==tib2[i] && tib3[j]==tib3[i] ) || (tib1[j]==tib3[i] && tib2[j]==tib2[i] && tib3[j]==tib1[i] ) ) {printed=1} 
	}
	if(printed==0) {
	    printf "%2s  %2s  %2s   %16.2f %8.2f\n", tib1[i],tib2[i],tib3[i], kb, 180*ang/3.14
	}
   }
}


