!=========================================================    
  subroutine planar_measure(nring,kring,x,y,z,fplan) 
!=========================================================    
! compute planarity index 0 < fplan < 1 defined as 
! (1/nring) abs( sum_i r_i x r_(i+1)/|r_i x r_(i+1)|) 
!=========================================================    

    implicit none 

!  args
    integer nring,kring(6)
    real*8 x(*),y(*),z(*), fplan
!  local
    real*8 vec(3),perp(3),r(3,6)
    integer j,jn,iat,jat

!------------executable part ----------------------------------

    if(nring.EQ.3) THEN 
       fplan=1.d0 
       return
    end if
    do j=1,nring 
       if(j.lt.nring) THEN  
          jn=j+1
       else
          jn=1
       end if
       iat= kring(j)
       jat= kring(jn)
       ! computes ring bond vectors
       r(1,j)=x(jat)-x(iat)
       r(2,j)=y(jat)-y(iat)
       r(3,j)=z(jat)-z(iat)
    end do
    vec=0.d0
    do j=1,nring 
       if(j.lt.nring) THEN  
          jn=j+1
       else
          jn=1
       end if
       call cross(r(1,j),r(1,jn),perp,1)
       vec=vec+perp
    end do
    call dot(vec,vec,fplan,0) 
    fplan=dsqrt(fplan)/float(nring) 
    return
  end subroutine planar_measure
