subroutine assign_type211(n,types,ato2,c,conn,iring,kring,nr,nrr,x,y,z,esp,impr,ki,grpt,ngrp,ngrph,igrp,ddc,bond,nb,in_ring,hybrid)
!--------------------------------------------------------------------------------------------
    implicit none
    character*2 types(n),ato2(n)
    integer c(n,7),impr(4,n),conn(n),iring(n),n,grpt(20,n),ngrp,ngrph,igrp(n),kring(6,nr),nr,nrr,bond(n,2),nb,in_ring(n)
    real*8  x(n),y(n),z(n),esp(n),ddc(n)
!   local
    real*8 r1(3),r2(3),r3(3),ra(3),rb(3),rdot,eps,pi,angle,total_charge,chargeh,fplan
    real*8 dx(2),dy(2),dz(2)
    integer i,ig,jg,j,j2,jat,iat,iat1,iat2,iat3,ki,iam,ct(7)
    character*1 ato
    character*3 hybrid(n)
    logical obound,hbound,cbound,nbound,sbound,arobound,carbo,nyl,lc1,lc2,sp2
    real*8 aconn,adist,adist2,dd(6),sigmad,arod,qhc,qh1,qh2,qh3,qh4,qh5,qha
    integer  ndist,nring,jn,k,kat,k1,kat2,nbiph,bond_biph(nr,2),nnbound,counth
    character*25 type_ring
!--------------------------------GAFF2---------------------------------------------------------------------------------
!# c  12.01         0.616               Sp2 C carbonyl group 
!# cs 12.01         0.616               Sp2 C in c=S
!# c1 12.01         0.360               Sp C
!# c2 12.01         0.360               Sp2 C  
!# c3 12.01         0.878               Sp3 C
!# ca 12.01         0.360               Sp2 C in pure aromatic systems
!# cp 12.01         0.360               Head Sp2 C that connect two rings in bip!henyl sys. 
!# cq 12.01         0.360               Head Sp2 C that connect two rings in bip!henyl sys. identical to cp 
!# cc 12.01         0.360               Sp2 carbons in non-pure aromatic systems
!# cd 12.01         0.360               Sp2 carbons in non-pure aromatic systems!, identical to cc
!# ce 12.01         0.360               Inner Sp2 carbons in conjugated systems
!# cf 12.01         0.360               Inner Sp2 carbons in conjugated systems, identical to ce
!# cg 12.01  ?       0.360               Inner Sp carbons in conjugated systems
!# ch 12.01  ?       0.360               Inner Sp carbons in conjugated systems, identical to cg
!# cx 12.01         0.360               Sp3 carbons in triangle systems
!# cy 12.01         0.360               Sp3 carbons in square systems
!# cu 12.01         0.360               Sp2 carbons in triangle systems
!# cv 12.01         0.360               Sp2 carbons in square systems
!# cz 12.01         0.360               Sp2 carbon in guanidine group
!# h1 1.008         0.135               H bonded to aliphatic carbon with 1 electrwd. group  
!# h2 1.008         0.135               H bonded to aliphatic carbon with 2 electrwd. group 
!# h3 1.008         0.135               H bonded to aliphatic carbon with 3 electrwd. group 
!# h4 1.008  ?       0.135               H bonded to non-sp3 carbon with 1 electrwd. group 
!# h5 1.008         0.135               H bonded to non-sp3 carbon with 2 electrwd. group 
!# ha 1.008         0.135               H bonded to aromatic carbon  
!# hc 1.008         0.135               H bonded to aliphatic carbon without electrwd. group 
!# hn 1.008         0.161               H bonded to nitrogen atoms
!# ho 1.008         0.135               Hydroxyl group
!# hp 1.008         0.135               H bonded to phosphate 
!# hs 1.008         0.135               Hydrogen bonded to sulphur 
!# hw 1.008         0.135               Hydrogen in water 
!# hx 1.008  ?       0.135               H bonded to C next to positively charged group  
!# f  19.00         0.320               Fluorine
!# cl 35.45         1.910               Chlorine 
!# br 79.90         2.880               Bromine 
!# i  126.9         4.690               Iodine 
!# si  28.1           -                 Silicon (tetravalent) 
!# n  14.01         0.530               Sp2 nitrogen in amide groups
!# n1 14.01         0.530               Sp N  
!# n2 14.01         0.530               aliphatic Sp2 N with two connected atoms 
!# n3 14.01         0.530               Sp3 N with three connected atoms
!# n4 14.01         0.530               Sp3 N with four connected atoms 
!# na 14.01         0.530               Sp2 N with three connected atoms 
!# nb 14.01         0.530               Sp2 N in pure aromatic systems 
!# nc 14.01         0.530               Sp2 N in non-pure aromatic systems
!# nd 14.01         0.530               Sp2 N in non-pure aromatic systems, identical to nc
!# ne 14.01         0.530               Inner Sp2 N in conjugated systems
!# nf 14.01         0.530               Inner Sp2 N in conjugated systems, identical to ne
!# nh 14.01         0.530               Amine N connected one or more aromatic rings 
!# no 14.01         0.530               Nitro N  
!# ns 14.01  ?       0.530               amind N, with 1 attached hydrogen atom
!# nt 14.01  ?       0.530               amide N, with 2 attached hydrogen atoms
!# nx 14.01  ?       0.530               like n4, but only has one hydrogen atom
!# ny 14.01  ?       0.530               like n4, but only has two hydrogen atoms
!# nz 14.01  ?       0.530               like n4, but only has three three hydrogen atoms
!# n+ 14.01  ?       0.530               NH4+
!# nu 14.01  ?       0.530               like nh, but only has one attached hydrogen atom
!# nv 14.01  ?       0.530               like nh, but only has two attached hydrogen atoms
!# n7 14.01  ?       0.530               like n3, but only has one attached hydrogen atom 
!# n8 14.01  ?       0.530               like n3, but only has two attached hydrogen atoms
!# n9 14.01  ?       0.530               NH3
!# rare small ring nitrogens 
!#ni 14.01         0.530               like n in RG3  (RG stands for 'ring') 
!#nj 14.01         0.530               like n in RG4
!#nk 14.01         0.530               like n4/nx/ny in RG3 
!#nl 14.01         0.530               like n4/nx/ny in RG4
!#nm 14.01         0.530               like nh in RG3 
!#nn 14.01         0.530               like nh in RG4
!#np 14.01         0.530               like n3 in RG3 
!#nq 14.01         0.530               like n3 in RG4
!#n5 14.01         0.530               like n7 in RG3 
!#n6 14.01         0.530               like n7 in RG4

!# o  16.00         0.434               Oxygen with one connected atom
!# oh 16.00         0.465               Oxygen in hydroxyl group
!# os 16.00         0.465               Ether and ester oxygen
!# ow 16.00         0.465               Oxygen in water 
!# p2 30.97         1.538               Phosphate with two connected atoms 
!# p3 30.97         1.538               Phosphate with three connected atoms, such as PH3
!# p4 30.97         1.538               Phosphate with three connected atoms, such as O=P(CH3)2
!# p5 30.97         1.538               Phosphate with four connected atoms, such as O=P(OH)3
!# pb 30.97         1.538               Sp2 P in pure aromatic systems 
!# pc 30.97  ?       1.538               Sp2 P in non-pure aromatic systems
!# pd 30.97  ?       1.538               Sp2 P in non-pure aromatic systems, identical to pc
!# pe 30.97  ?       1.538               Inner Sp2 P in conjugated systems
!# pf 30.97  ?       1.538               Inner Sp2 P in conjugated systems, identical to pe
!# px 30.97  ?       1.538               Special p4 in conjugated systems
!# py 30.97  ?       1.538               Special p5 in conjugated systems
!# s  32.06         2.900               S with one connected atom 
!# s2 32.06         2.900               S with two connected atom, involved at least one double bond  
!# s4 32.06         2.900               S with three connected atoms 
!# s6 32.06         2.900               S with four connected atoms 
!# sh 32.06         2.900               Sp3 S connected with hydrogen 
!# ss 32.06         2.900               Sp3 S in thio-ester and thio-ether
!# sx 32.06  ?       2.900               Special s4 in conjugated systems
!# sy 32.06  ?       2.900               Special s6 in conjugated systems
!# sp 32.06         2.900               ss in 3-memberred rings
!# sq 32.06         2.900               ss in 4-memberred rings

!   group charges for H assignment (based on Mulliken)
!   sp3 groups 
    qhc=0.10
    qh1=0.25
    qh2=0.40
!   sp2 groups 
    qha=0.05
    qh4=0.10
    qh5=0.25

    pi=dacos(-1.d0)
    eps=8.0
    arod=0.05
    ki=0
    pi=dacos(-1.d0)
    do i=1,n
       call up_low(ato2(i),2)
    end do

    types="x"    ! unassigned type.
    hybrid="s0"  ! default hybridization

!   downcase all labels
    do i=1,n
       call up_low(ato2(i),2)
    end do

!------------------------------------------------------------------------------------------------ 
!       STEP 1 : Assign ring atoms: 
!------------------------------------------------------------------------------------------------ 
! TY-R_C   c3*, ca,  cc,   cd, cu, cv, cx, cy, cz 
! TY-R_N   na,  nb,  nc,   nd,  
! TY-R_O   os*, 
! TY-R_P   p2*, p6*
! TY-R_S   ss*, s6* 
!           The star symbol indicate that not all of these
!           types are assigned  (i.e. c3 may be found also
!           in non ring system) 
!--------------------------------------------------------------------------------------------------
    do i=1,nrr 
       nring = 0
       do j=1,6 
          if(kring(j,i).ne.0) nring=nring+1
       end do
       aconn=0
       adist=0.d0
       adist2=0.d0
!      find mean connectivity and mean distance (atoms C N O)
       ndist =0 
       call planar_measure(nring,kring(1,i),x,y,z,fplan)
       do j=1,nring 
          if(j.lt.nring) THEN  
             jn=j+1
          else
             jn=1
          end if
          iat= kring(j,i)
          jat= kring(jn,i)
          if(ato2(iat)(1:1).ne."s".and.ato2(jat)(1:1).ne."s") then  
             if(ato2(iat)(1:1).ne."p".and.ato2(jat)(1:1).ne."p") then
                ndist=ndist + 1
                dd(j)=sqrt( (x(iat)-x(jat))**2 +   (y(iat)-y(jat))**2 +   (z(iat)-z(jat))**2 )
             end if
          end if
          aconn=aconn+conn(iat)
          adist=adist+dd(j) 
          adist2=adist2+dd(j)**2
       end do
       sigmad=sqrt(adist2/nring-(adist/nring)**2 )/(adist/nring)
       aconn=aconn/nring

       if(nring.eq.3) THEN 
          if(aconn.le.3) THEN 
             type_ring = "3-MEMBERED CONJUGATED "
          ELSE
             type_ring = "3-MEMBERED NON CONJUGATED"
          end if
          do j=1,nring 
             iat= kring(j,i)
             if(conn(iat).eq.3) THEN
                hybrid(iat)="sp2"
                if(ato2(iat)(1:1).eq."c") types(iat)="cu" 
                if(ato2(iat)(1:1).eq."n") THEN
                   if(aconn.le.3) THEN
                      types(iat)="na"
                   else
                      do k=1,conn(iat)
                         ct(k)=c(iat,k)
                      end do
                      hybrid(iat)="sp3"
                      if(counth(ct,conn(iat),ato2).eq.0) THEN
                         types(iat)="np"
                      else
                         types(iat)="n7"
                      endif
                   endif
                endif
             else if (conn(iat).eq.4) THEN 
                hybrid(iat)="sp3"
                if(ato2(iat)(1:1).eq."c") types(iat)="cx" 
                if(ato2(iat)(1:1).eq."n") types(iat)="nk" 
             end if
          end do
          go to 10
       else if(nring.eq.4) THEN  
          if(aconn.le.3) THEN 
             type_ring = "4-MEMBERED CONJUGATED "
          else
             type_ring = "4-MEMBERED NON CONJUGATED"
          end if
          do j=1,nring 
             iat= kring(j,i)
             if(conn(iat).eq.3) THEN 
                hybrid(iat)="sp2"
                if(ato2(iat)(1:1).eq."c") types(iat)="cv"
                if(ato2(iat)(1:1).eq."n") THEN
                   if(aconn.le.3) THEN
                      types(iat)="na"
                   else
                      hybrid(iat)="sp3"
                      do k=1,conn(iat)
                         ct(k)=c(iat,k)
                      end do
                      if(counth(ct,conn(iat),ato2).le.1) THEN
                         types(iat)="n6"
                      else
                         types(iat)="nq"
                      endif
                   endif
                endif
             else if (conn(iat).eq.4) THEN 
                if(ato2(iat)(1:1).eq."c") types(iat)="cy"
                if(ato2(iat)(1:1).eq."n") types(iat)="nl" 
                hybrid(iat)="sp3"
             end if
          end do
          go to 10
       else  ! nring > 4
          if(aconn.le.3.and.sigmad.lt.arod.and.fplan.gt.0.99) THEN ! cycle is planar aromatic  
             type_ring = "AROMATIC" 
             do j=1,nring 
                iat= kring(j,i)
                if(ato2(iat)(1:1).eq."c") types(iat)="ca" 
                if(ato2(iat)(1:1).eq."n") types(iat)="nb" 
                if(ato2(iat)(1:1).eq."s") types(iat)="s2" 
                if(ato2(iat)(1:1).eq."o") types(iat)="os"  ! in e.g. furan 
                if(ato2(iat)(1:1).eq."p") types(iat)="pb" 
                hybrid(iat)="sp2"
             end do
             
             !         check whether amide moieties ar in the "aromatic" ring  (e.g. terbacil, Vassetti ) 
             do j=1,nring 
                iat= kring(j,i)
                if(ato2(iat)(1:1).eq."n") THEN  ! examine amide nitrogen possibility 
                   do k=1,conn(iat)
                      kat=c(iat,k)
                      if(ato2(kat)(1:1).eq."c".and.conn(kat).eq.3) THEN 
                         do k1=1,conn(kat)
                            kat2=c(kat,k1)
                            if(ato2(kat2)(1:1).eq."o".and.conn(kat2).eq.1) THEN
                               !                           amide found! reset atom types
                               types(kat)="c"
                               if(nring.gt.4) THEN 
                                  types(iat)="n"
                               else if (nring.eq.4) THEN
                                  types(iat)="nj"
                               else
                                  types(iat)="ni"
                               endif
                               types(kat2)="o"
                            end if
                         end do
                      endif
                   end do
                end if
             end do
             iam=0
             !         reassign wrongly assigned ca if iam>0
             do j=1,nring
                iat= kring(j,i)
                if (types(iat).eq."c".OR.types(iat).eq."n") iam=iam+1 
             end do
             if(iam.eq.4) THEN  
                do j=1,nring
                   iat= kring(j,i)
                   if(types(iat).eq."ca") types(iat)="cc"
                end do
             end if
          else if(aconn.le.3.and.sigmad.gt.arod.and.fplan.gt.0.99) THEN ! cycle is planar conjugated 
             type_ring = "CONJUGATED" 
             do j=1,nring 
                if(j.lt.nring) THEN  
                   jn=j+1
                else
                   jn=1
                end if
                iat=kring(j,i) 
                !            if(types(iat).ne."x") go to 1  ! jump if types is already known
                jat=kring(jn,i) 
                if(ato2(iat)(1:1).eq."c") THEN  ! ring carbon  is either cc,cd or c
                   obound=.false.            ! check if c is bound to out of ring Oxygen 
                   nnbound=0                 ! check if c is part of a guanidinium group
                   do k=1,conn(iat)
                      kat=c(iat,k)
                      if(ato2(kat)(1:1).eq."o".and.conn(kat).eq.1) THEN 
                         obound=.true.
                      end if
                      if(ato2(kat)(1:1).eq."n") THEN 
                         nnbound=nnbound+1
                      end if
                   end do
                   if(obound) THEN 
                      types(iat)="c" 
                      goto 1
                   end if
                   if(nnbound.eq.3) THEN 
                      types(iat)="cz"
                      goto 1
                   end if
                   call bonds_rings(dd(j),iat,jat,ato2,types,conn,n) ! find also non carbon and put them in types(jat)
                   hybrid(iat)="sp2"
                   hybrid(jat)="sp2"
                end if
1               continue
                if(conn(iat).eq.4.and.ato2(iat)(1:1).eq."c") types(iat)="c3" ! reset to c3 if conn=4
             end do
             
          else if(aconn.gt.3.0.or.fplan.lt.0.99) THEN ! cycle is mostly non conjugated or non conjugated
             type_ring="MOSTLY NON CONJUGATED" 
             do j=1,nring 
                iat=kring(j,i) 
                if(conn(iat).eq.4) THEN 
                   if(ato2(iat)(1:1).eq."c") types(iat)="c3"
                   if(ato2(iat)(1:1).eq."p") types(iat)="p5"
                   if(ato2(iat)(1:1).eq."s") types(iat)="s6"
                   hybrid(iat)="sp3"
                else if(conn(iat).eq.3) then 
                   hybrid(iat)="sp2"
                   if(j.lt.nring) THEN  
                      jn=j+1
                   else
                      jn=1
                   end if
                   jat=kring(jn,i) 
                   if(ato2(iat)(1:1).eq."c") THEN  ! ring carbon  is either cc,cd or c
                      obound=.false.            ! check if c is bound to out of ring Oxygen 
                      do k=1,conn(iat)
                         kat=c(iat,k)
                         if(ato2(kat)(1:1).eq."o".and.conn(kat).eq.1) THEN 
                            obound=.true.
                         end if
                      end do
                      if(obound) THEN 
                         types(iat)="c" 
                         goto 2
                      end if
                      call bonds_rings(dd(j),iat,jat,ato2,types,conn,n) ! find also non carbon and put them in types(jat)
                   else if(ato2(iat)(1:1).eq."n") THEN  ! examine amide nitrogen possibility 
                      do k=1,conn(iat)
                         kat=c(iat,k)
                         if(ato2(kat)(1:1).eq."c".and.conn(kat).eq.3) THEN 
                            do k1=1,conn(kat)
                               kat2=c(kat,k1)
                               if(ato2(kat2)(1:1).eq."o".and.conn(kat2).eq.1) THEN
                                  types(iat)="n"
                                  go to 2
                               end if
                            end do
                         endif
                      end do
                   end if
                end if
2               continue
             end do
          end if
       endif
10     continue
       write(3,43) i,nring,fplan,aconn,sigmad,type_ring, (kring(j,i),ato2(kring(j,i)),j=1,nring)
43     format(14x,"---> Ring n. ",i2,":  members =",i2, " <plan_index> =",f8.4," <conn.> =",f8.2, " <dR> =",f8.2, & 
            /18x, " ring_type: ",A25, /16x,6(i4,1x,A2,3x))
    end do

!------------------------------------------------------------------------------------------------ 
!  STEP 2 : check for biphenyl rings renaming  "ca" types 
!------------------------------------------------------------------------------------------------ 
! TY-R_C  cp, cq 
! TY-R_N  np, nq  
!------------------------------------------------------------------------------------------------ 
    nbiph=0
    do i=1,n
       if(types(i).eq."ca".or.types(i).eq."nb") THEN 
          do j=1,conn(i)
             jat=c(i,j)
             lc1=in_ring(jat).ne.in_ring(i)
             lc2=iring(i).eq.6.and.iring(jat).eq.6
             if(types(jat).eq."ca".or.types(jat).eq."nb") THEN 
                if(lc1.and.lc2) THEN 
                   if(types(i).eq."ca") types(i)="cp"
!                   if(types(i).eq."nb") types(i)="np"
                   if(types(jat).eq."ca") types(jat)="cp"
!                   if(types(jat).eq."nb") types(jat)="np"
                   nbiph=nbiph+1
                   bond_biph(nbiph,1)=i
                   bond_biph(nbiph,2)=jat
                END IF
             end if
          end do
       end if
    end do

    write(3,*) nbiph, "---> biphenyl-type connections found " 

    if(nbiph.gt.1) THEN 
       write(3,29)
29     format(15x,"byphenyl bond",3x,"ato1",2x,"ato2","  types" ) 
       i=1
       iat1=bond_biph(1,1)
       iat2=bond_biph(1,2)
       write(3,30) i,iat1,iat2,types(iat1),types(iat2)
       do i=2,nbiph
          iat1=bond_biph(i,1)
          iat2=bond_biph(i,2)
          do j=1,conn(iat1) 
             jat=c(iat1,j)
             if(types(jat).eq."cp".and.jat.ne.iat2) THEN 
                types(iat1)="cq" 
                types(iat2)="cq"
             end if
          end do
           write(3,30) i,iat1,iat2,types(iat1),types(iat2)
30        format(15x,i10,2i5,2(3x,A2)) 
       end do
    end if

!------------------------------------------------------------------------------------------------ 
!   STEP 3  : Assign non ring atoms  on conjugated systems
!--------------------------------------------------------------------------------------------------
!  TY-C_C    ce, cf 
!  TY-C_N    ne, nf 
!--------------------------------------------------------------------------------------------------

    write(3,*) nb, "---> conjugated bonds found"  
    if(nb.gt.1) THEN  ! minimum of conjugated bons is 2
       write(3,14) 
14     format(15x,"index",2x,"length",8x,"indxs",1x,5x,"atoms",7x,"types") 
       do i=1,nb
          iat1=bond(i,1)
          iat2=bond(i,2)
          !      check for C--N=C--C conjugation. Can be carbonyl so exit 
          if(nb.le.2.and.(ato2(iat1)(1:1).eq."n".and.ato2(iat2)(1:1).eq."c")) exit
          if(nb.le.2.and.(ato2(iat1)(1:1).eq."c".and.ato2(iat2)(1:1).eq."n")) exit
          call up_low(ato2(iat1),2)
          call up_low(ato2(iat2),2)
          call ass_conj_name(ddc(i),ato2(iat1)(1:1),ato2(iat2)(1:1),types,n,iat1,iat2) 
          write(3,15) i,ddc(i),bond(i,1),bond(i,2),ato2(bond(i,1)),ato2(bond(i,2)),types(iat1),types(iat2)
15        format(15x,i5,f8.2,5x,2i4,5x,2(2x,a1),5x,2(2x,a2))
          hybrid(iat1)="sp2"
          hybrid(iat2)="sp2"
       end do
    end if


!------------------------------------------------------------------------------------------------ 
!   STEP 4  : Assign non ring atoms  and non conjugated systems atoms
!--------------------------------------------------------------------------------------------------
!---   four connected atoms
! TY-4_C    c3, 
! TY-4_N    n4, n no, na 
! TY-4_P    p5 
! TY-4 S    s6
! TY-4 Si   si
    do i=1,n
       if(conn(i).eq.4) THEN
          hybrid(i)="sp3"
          if(types(i).eq."x") THEN 
             if(ato2(i)(1:1).eq."c") types(i)="c3"
             if(ato2(i)(1:1).eq."n") types(i)="n4"
             if(ato2(i)(1:1).eq."p") types(i)="p5"
             if(ato2(i)(1:1).eq."s") THEN
                if(ato2(i)(2:2).ne."i" ) THEN
                   types(i)="s6" ! tetravalent sulphur  
                else 
                   types(i)="si" ! tetravalent silicon
                endif
             ENDIF
          end if
       end if
    end do
!----  three connected atoms
! TY-3_C   c, c2, 
! TY-3_N   n, no, na, nh, n3
! TY-3_P   p3, p4 
! TY-3_S   s4, s6
    do i=1,n
       if(types(i).ne."x") go to 102
!      reexamine unassigned types 
       if(conn(i).eq.3) THEN
          ! SP2 carbon
          hybrid(i)="sp2"
          if(ato2(i)(1:1).eq."c") then
             obound=.false.
             sbound=.false.
             do j=1,conn(i)
                iat=c(i,j)
                if(ato2(iat)(1:1).eq."o".and.conn(iat).eq.1) obound=.true.
                if(ato2(iat)(1:1).eq."s".and.conn(iat).eq.1) sbound=.true.
             end do
             if(obound) THEN
                types(i)="c"        
             else if(sbound) THEN
                types(i)="cs"   
             else
                types(i)="c2"
             end if
          end if
          ! SP2 phosphorus
          if(ato2(i)(1:1).eq."p") THEN 
             call check_angle(i,c(i,1),conn(i),x,y,z,angle)
             if(abs(angle).lt.eps.or.abs(angle-180.d0).lt.eps) THEN
                types(i)="p3"
                hybrid(i)="sp2"
             else
                types(i)="p4"
                hybrid(i)="sp3"
             end if
          end if
          if(ato2(i)(1:1).eq."s") THEN 
             call check_angle(i,c(i,1),conn(i),x,y,z,angle)
             if(abs(angle).lt.eps.or.abs(angle-180.d0).lt.eps) THEN
                types(i)="s4"
                hybrid(i)="sp2"
             else
                types(i)="s6"
                hybrid(i)="sp3"
            end if
          end if
!         sp2 nitrogen
          if(ato2(i)(1:1).eq."n") THEN
             iat1=c(i,1)
             iat2=c(i,2)
             iat3=c(i,3)
             r1(1)=x(iat1)-x(i)
             r2(1)=x(iat2)-x(i)
             r3(1)=x(iat3)-x(i)

             r1(2)=y(iat1)-y(i)
             r2(2)=y(iat2)-y(i)
             r3(2)=y(iat3)-y(i)

             r1(3)=z(iat1)-z(i)
             r2(3)=z(iat2)-z(i)
             r3(3)=z(iat3)-z(i)


             call cross(r1,r2,ra,1)
             call cross(r2,r3,rb,1)
             call dot(ra,rb,rdot,1)
             angle=dacos(rdot)*180.d0/pi
!            sp2 nitrogen
             if(abs(angle).lt.eps.or.abs(angle-180.d0).lt.eps) THEN
                hybrid(i)="sp2"
                carbo=.false.
                nyl=.false. 
                ! look for carbonyl 
                obound=.false.
                do j=1,conn(i)
                   iat=c(i,j)
                   if(ato2(iat)(1:1).eq."c") carbo=.true.
                   if(ato2(iat)(1:1).eq."o") obound=.true.
                   if(ato2(iat)(1:1).eq."c") THEN 
                      do j2=1,conn(iat) 
                         jat=c(iat,j2)
                         if(ato2(jat)(1:1).eq."o".and.conn(jat).eq.1) nyl=.true.
                      end do
                   end if
                end do
                if(carbo.and.nyl) THEN 
                   types(i)="n"
                else if (obound) THEN 
                   types(i)="no"
                else
                   types(i)="na"
                end if
             !sp3 nitrogen
             else
                hybrid(i)="sp3"
                hbound=.false.
                do j=1,conn(i)
                   iat=c(i,j)
                   if(ato2(iat)(1:1).eq."h") hbound=.true.
                   if(types(iat).eq."ca".or.types(iat).eq."nb") arobound=.true.
                end do
                if(arobound) THEN 
                   types(i)="nh"
                else
                   types(i)="n3"
                end if
             end if
          end if
       end if
102    continue
    end do

! look for guanidinium
    do i=1,n
       if(conn(i).eq.3) THEN
          hybrid(i)="sp2"
          if(ato2(i)(1:1).eq."c") THEN  
             nnbound=0 
             do k=1,conn(i)
                kat=c(i,k)
                if(ato2(kat)(1:1).eq."n") THEN 
                   nnbound=nnbound+1
                end if
             end do
             if(nnbound.eq.3) THEN 
                types(i)="cz" 
                do k=1,conn(i)
                   kat=c(i,k)
                   types(kat)="na" ! all hydrogens must be sp2
                   if(hybrid(kat).eq."sp3") THEN  ! This must be distorted: add improper torsion anyway 
                      ki=ki+1
                      impr(1,ki)=c(kat,1)
                      impr(3,ki)=kat               ! central atom is the third 
                      impr(2,ki)=c(kat,2)
                      impr(4,ki)=c(kat,3)
                 end if
                end do
             end if
          end if
       end if
    end do

!----  twoconnected atoms
! TY-2_C   c1, 
! TY-2_N   n2
! TY-2_O   oh, os
! TY-2_P   p2
! TY-2_S   sh, ss
    do i=1,n
       ato=ato2(i)
       call up_low(ato2(i),2)
       if(types(i).ne."x") go to 103
       if(conn(i).eq.2) THEN
          hybrid(i)="sp1"
          if(ato2(i)(1:1).eq."c")  THEN
             lc1=.false.
             do j=1,conn(i)
                if(hybrid(j).eq."sp2") then
                   lc1=.true.
                endif
             end do
             if(lc1) THEN  ! sp1 carbon is attached to conjugated system
                types(i)="cg"
             else
                types(i)="c1"
             endif
          endif
          if(ato2(i)(1:1).eq."n".and.types(i).eq."x") THEN
             hybrid(i)="sp2" ! n is sp2 ; reset hybridization
             types(i)="n2"
          endif
          if(ato2(i)(1:1).eq."p".and.types(i).eq."x") types(i)="p2"
          if(ato2(i)(1:1).eq."o") THEN 
             hbound=.false.
             do j=1,conn(i)
                iat=c(i,j)
                call up_low(ato2(iat),2)
                if(ato2(iat)(1:1).eq."h") hbound=.true.
             end do
             if(hbound) THEN 
                types(i)="oh"
             else
                if(types(i).eq."x") types(i)="os"
             end if
          end if
          if(ato2(i)(1:1).eq."s") THEN
             hbound=.false.
             cbound=.false.
             obound=.false.
             do j=1,conn(i)
                iat=c(i,j)
                call up_low(ato2(iat),2)
                if(ato2(iat)(1:1).eq."h") hbound=.true.
             end do
             if(hbound) THEN
                types(i)="sh"
             else
                types(i)="ss"
             end if
          end if
       end if
103    continue
    end do
!----  one connected atoms [non ring non conjugated ]
!   TY-1_H   ho, h1, h2, h3, h5, hc, hn, hp, hs  
!   TY-3_C   c   (type reset if found bound to O(1)) 
!   TY-1_N   n1
!   TY-1_O   o
!   TY-1_S   s2
!   TY-1_L  f, cl, br, i
    do i=1,n
!      one connected atom; types should be "x".  NO JUMP is necessary
       if(conn(i).eq.1) THEN
          if(ato2(i)(1:1).eq."n")  types(i)="n1"
          if(ato2(i)(1:1).eq."f") types(i)="f"
          if(ato2(i).eq."cl") types(i)="cl"
          if(ato2(i).eq."br") types(i)="br"
          if (ato2(i)(1:1).eq."i") types(i)="i" 
          if (ato2(i)(1:1).eq."s") types(i)="s "
          if(ato2(i)(1:1).eq."o") THEN 
             types(i)="o"   ! below check if O-connected atoms was cf or ce and reset it to c if so
             if(types(c(i,1)).eq."cf".or.types(c(i,1)).eq."ce")  types(c(i,1))="c"
          end if
          if(ato2(i)(1:1).eq."h") THEN   ! hydrogens
             iat=c(i,1)
             if(ato2(iat)(1:1).eq."o") then 
                types(i)="ho" 
             else if(ato2(iat)(1:1).eq."n") then
                if(types(iat).eq."nb") THEN
                   types(i)="hn"
                else
                   types(i)="hn"
                end if
             else if(ato2(iat)(1:1).eq."p") then 
                types(i)="hp"
             else if(ato2(iat)(1:1).eq."s") then 
                types(i)="hs"
             else if(ato2(iat)(1:1).eq."c") then 
                sp2=types(iat).eq."ca".or. &
                    types(iat).eq."cc".or. &
                    types(iat).eq."cd".or. &
                    types(iat).eq."ce".or. &
                    types(iat).eq."c1".or. &
                    types(iat).eq."cf".or. &
                    types(iat).eq."cu".or. &
                    types(iat).eq."cv".or. &
                    types(iat).eq."cs".or. &
                    types(iat).eq."c ".or. &
                    types(iat).eq."c2"
                if(sp2) THEN 
                   ig=igrp(iat)   ! get the group of carbon
                   total_charge=0.d0 ! finds the charge on XH_n sp3 group  
                   do jat=2,grpt(1,ig) 
                      jg=grpt(jat,ig) 
                      total_charge=total_charge + esp(jg)
                   end do
                   if(total_charge.lt.qha ) THEN
                      if(types(iat).eq."ca") THEN 
                         types(i)="ha"
                      else
                         types(i)="hc"
                      end if
                   else if (total_charge.ge.qha.and.total_charge.lt.qh4)  THEN
                      if(types(iat).eq."ca") THEN 
                         types(i)="h4"
                      else
                         types(i)="h1"
                      end if
                   else if (total_charge.ge.qh4.and.total_charge.lt.qh5)  THEN
                      if(types(iat).eq."ca") THEN 
                         types(i)="h5"
                      else
                         types(i)="h2"
                      end if
                   else
                      if(types(iat).eq."ca") THEN 
                         types(i)="h5"
                      else
                         types(i)="h3"   
                      end if
                   end if
                   if(types(iat).eq."c ") types(i)="h1" ! default h2 for H-CO hydrogen
                else ! non aromatic carbon 
                   ig=igrp(iat)      ! get the group of carbon
                   total_charge=0.d0 ! finds the charge on XH_n sp3 group  
                   do jat=2,grpt(1,ig) 
                      jg=grpt(jat,ig) 
                      total_charge=total_charge + esp(jg)
                   end do
                   if(abs(total_charge).lt.qhc ) THEN 
                      types(i)="hc"
                   else if (abs(total_charge).ge.qhc.and.abs(total_charge).lt.qh1)  THEN  
                      types(i)="h1"
                   else if (abs(total_charge).ge.qh1.and.abs(total_charge).lt.qh2)  THEN  
                      types(i)="h2"
                   else 
                      types(i)="h3"
                   end if
                end if
             end if
          end if
       end if  ! end of connected 1 
    end do
!--------------------------Assignment ends here ------------------------------------------------

!   find improper torsions    
    do i=1,n
       if(conn(i).eq.3) THEN
          ! SP2 carbon
          if(ato2(i)(1:1).eq."c") then
             ki=ki+1
             impr(1,ki)=c(i,1)
             impr(3,ki)=i               ! central atom is the third 
             impr(2,ki)=c(i,2)
             impr(4,ki)=c(i,3)
          end if
          ! SP2 phosphorus
          if(ato2(i)(1:1).eq."p") THEN 
             call check_angle(i,c(i,1),conn(i),x,y,z,angle) 
             angle=dacos(rdot)*180.d0/pi
             if(abs(angle).lt.eps.or.abs(angle-180.d0).lt.eps) THEN
                ki=ki+1
                impr(1,ki)=c(i,1)
                impr(3,ki)=i
                impr(2,ki)=c(i,2)
                impr(4,ki)=c(i,3)
             end if
          end if
          if(ato2(i)(1:1).eq."s") THEN 
             call check_angle(i,c(i,1),conn(i),x,y,z,angle) 
             angle=dacos(rdot)*180.d0/pi
             if(abs(angle).lt.eps.or.abs(angle-180.d0).lt.eps) THEN
                ki=ki+1
                impr(1,ki)=c(i,1)
                impr(3,ki)=i
                impr(2,ki)=c(i,2)
                impr(4,ki)=c(i,3)
             end if
          end if
!         sp2 nitrogen
          if(ato2(i)(1:1).eq."n") THEN
             call check_angle(i,c(i,1),conn(i),x,y,z,angle) 
!            sp2 nitrogen
             if(abs(angle).lt.eps.or.abs(angle-180.d0).lt.eps) THEN
                ki=ki+1
                impr(1,ki)=c(i,1)
                impr(3,ki)=i
                impr(2,ki)=c(i,2)
                impr(4,ki)=c(i,3)
             !sp3 nitrogen
             end if
          end if
       end if
    end do

  end subroutine assign_type211
  integer function counth(c,n,ato2)
    character*2 ato2(*)
    integer c(7),n
    counth=0
    do i=1,n
       if(ato2(c(i))(1:1).eq."h") counth=counth+1 
    end do
    return
  end function counth

  subroutine check_angle(i,c,conn,x,y,z,angle)
    implicit none
    integer c(*),conn,i,j,iat
    real*8 x(*),y(*),z(*),r(3,3),ra,rb,rdot,angle,pi
    pi=dacos(-1.d0)
    if(conn.eq.3) THEN 
       do j=1,conn
          iat=c(j)
          r(j,1)=x(iat)-x(i)
          r(j,2)=y(iat)-y(i)
          r(j,3)=z(iat)-z(i)
       end do
       call cross(r(1,1),r(2,1),ra,1)
       call cross(r(2,1),r(3,1),rb,1)
       call dot(ra,rb,rdot,1)
       angle=dacos(rdot)*180.d0/pi
    end if
    if(conn.eq.2) THEN 
       do j=1,conn
          iat=c(j)
          r(j,1)=x(iat)-x(i) 
          r(j,2)=y(iat)-y(i) 
          r(j,3)=z(iat)-z(i)
       end do
       call dot(r(1,1),r(2,1),rdot,1)
       angle=abs(dacos(rdot)*180.d0/pi)
    end if
  end subroutine check_angle
