#!/bin/bash
#  download pdb file from PDB and finds gap hetero, metals and chains in the pdb file 
#  and printout relevant info 
# 
# syntax: 
#   ./check_pdb_code [-f] pdbcode
#    "pdbcode" is the alphanumeric code of the PDB file
#    if -f option is used; no wget from PDB ; file with pdbcode=xxxx 
#    [ i.e. pdbxxxx.ent] is assumed to be local  
#

local=0
while getopts ":fl" opt; do 
    case $opt in 
	f) 
	    local=1; 
	    ;;
	l) 
	    local=1; 
	    ;;
	\?) 
	    echo "invalid option"
	    ;;
    esac
done
code=${!#}

# wget the file if -f is not given 
if [ $local != 1 ] ; then 
    wget  ftp://ftp.ebi.ac.uk/pub/databases/pdb/data/structures/all/pdb/pdb${code}.ent.gz; 
    gzip -d pdb${code}.ent.gz ; mv   pdb${code}.ent ${code}.pdb
else
    mv $code .
    if [ $extf != ".pdb" ] ; then
	echo  "Not a pdb file"
	exit
    else
      code=`echo $code | awk '{print substr($1,1,length($1)-4)}'` 
    fi
#   check local uploaded file meets the PDBrestore standard
    echo "<br> checking that the uploaded $code.pdb meets the PDBrestore standard ...<br>"
    nrs=`grep "ATOM " ${code}.pdb | grep " CA " | wc -l`
    defective=0
    if [ $nrs == "0" ] ; then
	echo "<p style="color:#FF0000";>  <b> NRESIDUES is ZERO </b>: <br> no 'CA' atom found.  Check that labels in $code.pdb file follows PDB standard"
	defective=1
    fi   
    nsq=`grep "SEQRES" ${code}.pdb | wc -l`
    if [ $nsq == "0" ] ; then
	echo "<p style="color:#FF0000";>  <b> no 'SEQRES' keyword found </b>: <br> insert the SSEQRES lines in the $code.pdb file before uploading"
	grep -e "^ATOM " $code.pdb | grep " CA " |  ./make_seqres.awk > seqres
	cat seqres
	defective=1
    fi 
    if [ $defective == 1 ]; then
	exit
    fi
fi
if [ ! -s $code.pdb ] ; then
    echo "<p style="color:#FF0000";> PDBfile $code is empty; check the spelling </p>"
    echo "PDBfile $code is empty; check the spelling " > failures/$code.pdb
    exit
fi

# scanning for general info 
echo ""  > $code.OUT
echo "<b> == GENERAL SECTION  </b>" >> $code.OUT
( printf "    NRESIDUE "; grep "ATOM " ${code}.pdb | grep " CA " | wc -l  ) >> $code.OUT
awk '/TITLE/{print "   ", $0}' ${code}.pdb >> $code.OUT
awk '/DOI/{print "   ", $0}' ${code}.pdb >> $code.OUT
 
# scan for chains info
echo "" >> $code.OUT
echo " <b> == CHAIN SECTION </b>" >> $code.OUT
awk '{\
    if($1=="ENDMDL") {\
	exit\
    }\
    if($1=="ATOM") {\
	{\
	    c=substr($0,22,1); \
	    n[c]+=1;\
	} \
    }\
}\
END {\
    if(n["A"]!=0) print "    chain A", n["A"];  \
    if(n["B"]!=0) print "    chain B", n["B"];  \
    if(n["C"]!=0) print "    chain C", n["C"];  \
    if(n["D"]!=0) print "    chain D", n["D"];  \
    if(n["E"]!=0) print "    chain E", n["E"];  \
    if(n["F"]!=0) print "    chain F", n["F"];  \
    if(n["G"]!=0) print "    chain G", n["G"];  \
    if(n["H"]!=0) print "    chain H", n["H"];  \
    if(n["J"]!=0) print "    chain J", n["J"];  \
    if(n["K"]!=0) print "    chain K", n["K"];  \
    if(n["I"]!=0) print "    chain I", n["I"];  \
    if(n["L"]!=0) print "    chain L", n["L"];  \
    if(n["M"]!=0) print "    chain M", n["M"];  \
    if(n["N"]!=0) print "    chain N", n["N"];  \
    if(n["P"]!=0) print "    chain P", n["P"];  \
    if(n["Q"]!=0) print "    chain Q", n["Q"];  \
    if(n["R"]!=0) print "    chain R", n["R"];  \
    if(n["S"]!=0) print "    chain S", n["S"];  \
    if(n["T"]!=0) print "    chain T", n["T"];  \
    if(n["U"]!=0) print "    chain U", n["U"];  \
    if(n["V"]!=0) print "    chain V", n["V"];  \
    if(n["Z"]!=0) print "    chain Z", n["Z"];  \
    if(n["X"]!=0) print "    chain X", n["X"];  \
    if(n["nochain"]!=0) print "    nochain ", n[" "];  \
}' ${code}.pdb >> $code.OUT

#generate the protein image DO NOT WORK
# rm vmdscene.tga >& /dev/null
# echo "vmd -e fig.vmd  -size 800 560  ${code}.pdb  >& /dev/null"
# vmd -e fig.vmd  -size 800 560  ${code}.pdb
# convert vmdscene.tga test.jpg

# scanning for gaps 
echo "" >> $code.OUT
echo " <b> == GAP SECTION  </b>" >> $code.OUT

./findgp.awk  ${code}.pdb   >> $code.OUT 

# search for hetero and metals 
echo "" >> $code.OUT
echo "<b> == HETERO ATOMS SECTION </b>"  >> $code.OUT

./hetero.awk $code.pdb >> $code.OUT
echo "<pre>"
cat $code.OUT
echo "</pre>"

# create a new html page for action fixpdb.php

echo "<html>" > $code.html
echo "<form action="fixpdb.php" method="post" enctype="multipart/form-data">"  >>  $code.html
echo "<pre>" >>  $code.html
cat $code.OUT >>  $code.html 
echo "</pre>" >>  $code.html
echo "<form action="fixpdb.php" method="post" enctype="multipart/form-data">"
-
echo "<center>"  >>$code.html
echo " PDB   <select name="pdbcode">" >>$code.html
echo "    <option value="${code}">$code </option>" >>$code.html
echo "</select>" >>$code.html

echo " <b> CHAIN? </b> <select name="chain">" >>$code.html
echo "    <option value="A">A </option>" >>$code.html
echo "    <option value="B">B </option>" >>$code.html
echo "    <option value="C">C </option>" >>$code.html
echo "    <option value="D">D </option>" >>$code.html
echo "    <option value="E">E </option>" >>$code.html
echo "    <option value="F">F </option>" >>$code.html
echo "    <option value="G">G </option>" >>$code.html
echo "    <option value="H">H </option>" >>$code.html
echo "    <option value="J">J </option>" >>$code.html
echo "    <option value="K">K </option>" >>$code.html
echo "    <option value="I">I </option>" >>$code.html
echo "    <option value="L">L </option>" >>$code.html
echo "    <option value="M">M </option>" >>$code.html
echo "    <option value="N">N </option>" >>$code.html
echo "    <option value="P">P </option>" >>$code.html
echo "    <option value="Q">Q </option>" >>$code.html
echo "    <option value="R">R </option>" >>$code.html
echo "    <option value="S">S </option>" >>$code.html
echo "    <option value="T">T </option>" >>$code.html
echo "    <option value="U">U </option>" >>$code.html
echo "    <option value="V">V </option>" >>$code.html
echo "    <option value="Z">Z </option>" >>$code.html
echo "    <option value="X">X </option>" >>$code.html
echo "    <option value="?">nochain</option>" >>$code.html
echo "</select>" >>$code.html

echo " <b> FIX GAPS? </b> <select name="gaps">" >>$code.html
echo "    <option value="yes">yes </option>" >>$code.html
echo "    <option value="no">no </option>" >>$code.html
echo "</select>" >>$code.html

echo " <b> LIGAND? </b> <input type="text" name="ligand " />"   >>$code.html

echo " <b> SOLVATE? </b> <select name="water">" >>$code.html
echo "    <option value="0">NO </option>" >>$code.html
echo "    <option value="opc3">OPC3 </option>" >>$code.html
echo "    <option value="tip3">TIP3P </option>" >>$code.html
echo "    <option value="spce">SPCE </option>" >>$code.html
echo "</select>" >>$code.html


echo "</center>"  >>$code.html
echo '<p><input type="submit" name="Submit" style="width:200px; height:50px; font-size:20px; border: red; border-style:solid; border-width:3px" value="submit" /></p>' >>$code.html
echo "</center>"  >>$code.html

echo "</html>" >>$code.html
echo "<html>"
echo "<b> Make your choices for CHAIN and LIGAND and go to <a href="$code.html"> THIS PAGE </a>  </b>"
echo "<br>"
echo "<br>"
echo "<br>"
echo "<hr>"
echo "           &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp  or go back to <b> <a href="pdbrestore.html"> PDBrestore </a> </b>"
echo "</html>" >> $code.html

#echo "<style>" >> $code.html
#echo "body {" >> $code.html
#echo "  background-image: url('test.jpg');" >> $code.html
#echo "  background-repeat: no-repeat;" >> $code.html
#echo "  background-size: contain;" >> $code.html
#echo "}" >> $code.html
#echo "</style>"  >> $code.html
#echo "</html>"  >> $code.html
