#!/bin/bash

# Syntax: orac  [options] input_file 
#  where 
#   options: -t -> [Intel/PARALLEL/Intel_PARALLEL]. Default is gfortran
#            -n -> do not try to recompile
#            -p -> Path to orac src 
#            -h -> display this help
# ----------------------------------------------------------------------
# Help: copy first comments block in this file
# ----------------------------------------------------------------------
 
function Help {
 head -9 $0  | tail -7 
 exit
}

dir=$HOME/ORAC/trunk
exe="default"
comp="default"
INPUT=${!#} 
while getopts ":nt:p:h" flag; 
do
    case $flag in
        n) comp="NO"; if  [ $# -eq 1 ]; then Help ; fi ;;
        t) exe=${OPTARG};  echo "optarg" $OPTARG ;;
        p) dir=${OPTARG} ;;
        h) Help ;; 
    esac
done
if [ $# -eq 0 ];  then  
    Help; exit 
fi
if [ -e $INPUT ];  then 
  echo "Iput file = "  $INPUT"; Executable =" $exe " ORAC path = " $dir
else
 echo "Input file " $INPUT " not found"   
 exit 
fi 

if [ $comp != "NO" ]; then
    echo "Compiling orac according to input....."
    $dir/configure $INPUT > ${dir}/src/config.H
    make -C ${dir}/src $exe
    echo "Compilation done.  Program starts.. "
    ${dir}/src/$exe/orac_Linux < $INPUT 
else
    echo ${dir}/src/$exe/orac_Linux < $INPUT 
    ${dir}/src/$exe/orac_Linux < $INPUT 
fi