c================= RCS HEADER ===================================
c -- RCS $Author: procacci $ $Date: 2015/04/28 22:28:03 $
c -- RCS $Revision: 1.1 $ 
c================= RCS HEADER ===================================
      SUBROUTINE POWELL(P,XI,N,NP,FTOL,ITER,FRET)
      implicit real*8 (a-h,o-z)
c    
      parameter (nmax=200,itmax=20)
      REAL*8 P(NP),XI(NP,NP),PT(NMAX),PTT(NMAX),XIT(NMAX)
      FRET=FUNC(P)
      DO 11 J=1,N
        PT(J)=P(J)
11    CONTINUE
      ITER=0
1     ITER=ITER+1
      FP=FRET
      if(fret.ge.1.d25) return
      IBIG=0
      DEL=0.
      DO 13 I=1,N
        DO 12 J=1,N
          XIT(J)=XI(J,I)
12      CONTINUE
        CALL LINMIN(P,XIT,N,FRET)
        IF(ABS(FP-FRET).GT.DEL)THEN
          DEL=ABS(FP-FRET)
          IBIG=I
        ENDIF
13    CONTINUE
      IF(2.*ABS(FP-FRET).LE.FTOL*(ABS(FP)+ABS(FRET)))RETURN
      IF(ITER.EQ.ITMAX) then
	 write (6,*) 'Powell exceeding maximum iterations.'
	 return
      endif
      DO 14 J=1,N
        PTT(J)=2.*P(J)-PT(J)
        XIT(J)=P(J)-PT(J)
        PT(J)=P(J)
14    CONTINUE
      FPTT=FUNC(PTT)
      IF(FPTT.GE.FP)GO TO 1
      T=2.*(FP-2.*FRET+FPTT)*(FP-FRET-DEL)**2-DEL*(FP-FPTT)**2
      IF(T.GE.0.)GO TO 1
      CALL LINMIN(P,XIT,N,FRET)
      DO 15 J=1,N
        XI(J,IBIG)=XIT(J)
15    CONTINUE
      GO TO 1
      END
      SUBROUTINE LINMIN(P,XI,N,FRET)                                            
      implicit real*8 (a-h,o-z)
c      include 'dimen.inc' 
      integer nmax 
      parameter (nmax=200,TOL=1.D-4)
      EXTERNAL F1DIM                                                            
      REAL*8 P(N),XI(N)                                                      
      COMMON /F1COM/ PCOM(NMAX),XICOM(NMAX),NCOM
      NCOM=N                                                                    
      DO 11 J=1,N
     &     
        PCOM(J)=P(J)                                                            
        XICOM(J)=XI(J)                                                          
11    CONTINUE                                                                  
      AX=0.                                                                     
      XX=1.                                                                     
      BX=2.                                                                     
      CALL MNBRAK(AX,XX,BX,FA,FX,FB,F1DIM)                                      
      FRET=BRENT(AX,XX,BX,F1DIM,TOL,XMIN)                                       
      DO 12 J=1,N                                                               
        XI(J)=XMIN*XI(J)                                                        
        P(J)=P(J)+XI(J)                                                         
12    CONTINUE                                                                  
      RETURN                                                                    
      END                                                                       

      SUBROUTINE MNBRAK(AX,BX,CX,FA,FB,FC,F1DIM)                                 
      implicit real*8 (a-h,o-z)
      PARAMETER (GOLD=1.618034, GLIMIT=100., TINY=1.D-40)                       
      EXTERNAL F1DIM
      FA=F1DIM(AX)                                                               
      FB=F1DIM(BX)     
      if(fa.gt.1.d99) write(6,*) "this is a gfortran bug"
      IF(FB.GT.FA)THEN                                                          
        DUM=AX                                                                  
        AX=BX                                                                   
        BX=DUM                                                                  
        DUM=FB                                                                  
        FB=FA                                                                   
        FA=DUM                                                                  
      ENDIF                                                                     
      CX=BX+GOLD*(BX-AX)                                                        
      FC=F1DIM(CX)                                                               
1     IF(FB.GE.FC)THEN                                                          
        R=(BX-AX)*(FB-FC)                                                       
        Q=(BX-CX)*(FB-FA)                                                       
        U=BX-((BX-CX)*Q-(BX-AX)*R)/(2.*SIGN(MAX(ABS(Q-R),TINY),Q-R))            
        ULIM=BX+GLIMIT*(CX-BX)                                                  
        IF((BX-U)*(U-CX).GT.0.)THEN                                             
          FU=F1DIM(U)                                                            
          IF(FU.LT.FC)THEN                                                      
            AX=BX                                                               
            FA=FB                                                               
            BX=U                                                                
            FB=FU                                                               
            GO TO 1                                                             
          ELSE IF(FU.GT.FB)THEN                                                 
            CX=U                                                                
            FC=FU                                                               
            GO TO 1                                                             
          ENDIF                                                                 
          U=CX+GOLD*(CX-BX)                                                     
          FU=F1DIM(U)                                                            
        ELSE IF((CX-U)*(U-ULIM).GT.0.)THEN                                      
          FU=F1DIM(U)                                                            
          IF(FU.LT.FC)THEN                                                      
            BX=CX                                                               
            CX=U                                                                
            U=CX+GOLD*(CX-BX)                                                   
            FB=FC                                                               
            FC=FU                                                               
            FU=F1DIM(U)                                                          
          ENDIF                                                                 
        ELSE IF((U-ULIM)*(ULIM-CX).GE.0.)THEN                                   
          U=ULIM                                                                
          FU=F1DIM(U)                                                            
        ELSE                                                                    
          U=CX+GOLD*(CX-BX)                                                     
          FU=F1DIM(U)                                                            
        ENDIF                                                                   
        AX=BX                                                                   
        BX=CX                                                                   
        CX=U                                                                    
        FA=FB                                                                   
        FB=FC                                                                   
        FC=FU                                                                   
        GO TO 1                                                                 
      ENDIF                                                                     
      RETURN                                                                    
      END                                                                       
      FUNCTION BRENT(AX,BX,CX,F,TOL,XMIN)                                       
      implicit real*8 (a-h,o-z)
      PARAMETER (ITMAX=1000,CGOLD=.3819660,ZEPS=1.0D-20) 
      EXTERNAL F 
      A=MIN(AX,CX)                                                              
      B=MAX(AX,CX)                                                              
      V=BX                                                                      
      W=V                                                                       
      X=V                                                                       
      E=0.                                                                      
      FX=F(X)                                                                   
      FV=FX                                                                     
      FW=FX                                                                     
      DO 11 ITER=1,ITMAX                                                        
        XM=0.5*(A+B)                                                            
        TOL1=TOL*ABS(X)+ZEPS                                                    
        TOL2=2.*TOL1                                                            
        IF(ABS(X-XM).LE.(TOL2-.5*(B-A))) GOTO 3                                 
        IF(ABS(E).GT.TOL1) THEN                                                 
          R=(X-W)*(FX-FV)                                                       
          Q=(X-V)*(FX-FW)                                                       
          P=(X-V)*Q-(X-W)*R                                                     
          Q=2.*(Q-R)                                                            
          IF(Q.GT.0.) P=-P                                                      
          Q=ABS(Q)                                                              
          ETEMP=E                                                               
          E=D                                                                   
          IF(ABS(P).GE.ABS(.5*Q*ETEMP).OR.P.LE.Q*(A-X).OR.                      
     *        P.GE.Q*(B-X)) GOTO 1                                              
          D=P/Q                                                                 
          U=X+D                                                                 
          IF(U-A.LT.TOL2 .OR. B-U.LT.TOL2) D=SIGN(TOL1,XM-X)                    
          GOTO 2                                                                
        ENDIF                                                                   
1       IF(X.GE.XM) THEN                                                        
          E=A-X                                                                 
        ELSE                                                                    
          E=B-X                                                                 
        ENDIF                                                                   
        D=CGOLD*E                                                               
2       IF(ABS(D).GE.TOL1) THEN                                                 
          U=X+D                                                                 
        ELSE                                                                    
          U=X+SIGN(TOL1,D)                                                      
        ENDIF                                                                   
        FU=F(U)                                                                 
        IF(FU.LE.FX) THEN                                                       
          IF(U.GE.X) THEN                                                       
            A=X                                                                 
          ELSE                                                                  
            B=X                                                                 
          ENDIF                                                                 
          V=W                                                                   
          FV=FW                                                                 
          W=X                                                                   
          FW=FX                                                                 
          X=U                                                                   
          FX=FU                                                                 
        ELSE                                                                    
          IF(U.LT.X) THEN                                                       
            A=U                                                                 
          ELSE                                                                  
            B=U                                                                 
          ENDIF                                                                 
          IF(FU.LE.FW .OR. W.EQ.X) THEN                                         
            V=W                                                                 
            FV=FW                                                               
            W=U                                                                 
            FW=FU                                                               
          ELSE IF(FU.LE.FV .OR. V.EQ.X .OR. V.EQ.W) THEN                        
            V=U                                                                 
            FV=FU                                                               
          ENDIF                                                                 
        ENDIF                                                                   
11    CONTINUE                                                                  
      WRITE(6,*) 'Brent exceed maximum iterations.'
      XMIN=X                                                                    
      BRENT=FX                                                                  
      RETURN     
3     XMIN=X                                                                    
      BRENT=FX                                                                  
      RETURN                                                                    
      END                                                                       
      FUNCTION F1DIM(X)                                                         
      implicit real*8 (a-h,o-z)
c      include 'dimen.inc' 
      integer nmax 
      parameter (nmax=200)
      COMMON /F1COM/ PCOM(NMAX),XICOM(NMAX),NCOM
      REAL*8  XT(NMAX)                                                        
      DO 11 J=1,NCOM                                                            
        XT(J)=PCOM(J)+X*XICOM(J)                                                
11    CONTINUE                                                                  
      F1DIM=FUNC(XT)                                                            
      RETURN                                                                    
      END                                                                       


* ======================================================================
* NIST Guide to Available Math Software.
* Fullsource for module DUNI from package NMS.
* Retrieved from TIBER on Thu Jan 30 10:40:11 1997.
* ======================================================================
      FUNCTION DUNI()
C***BEGIN PROLOGUE  DUNI
C***DATE WRITTEN   880714 (YYMMDD)
C***REVISION DATE  880714 (YYMMDD)
C***CATEGORY NO.  L6A21
C***KEYWORDS  RANDOM NUMBERS, UNIFORM RANDOM NUMBERS
C***AUTHOR    KAHANER, DAVID, SCIENTIFIC COMPUTING DIVISION, NBS
C             MARSAGLIA, GEORGE, SUPERCOMPUTER RES. INST., FLORIDA ST. U.
C
C***PURPOSE  THIS ROUTINE GENERATES DOUBLE PRECISION UNIFORM
C             RANDOM NUMBERS ON [0,1)
C***DESCRIPTION
C        COMPUTES DOUBLE PRECISION UNIFORM NUMBERS ON [0,1).
C           FROM THE BOOK, "NUMERICAL METHODS AND SOFTWARE" BY
C                D. KAHANER, C. MOLER, S. NASH
C                PRENTICE HALL, 1988
C
C       USAGE: 
C              TO INITIALIZE THE GENERATOR
C                   USEED = DUSTAR(ISEED)
C               WHERE: ISEED IS ANY NONZERO INTEGER
C                  WILL RETURN FLOATING POINT VALUE OF ISEED.
C
C               SUBSEQUENTLY
C                       U = DUNI()
C                  WILL RETURN A REAL UNIFORM ON [0,1)
C
C                ONE INITIALIZATION IS NECESSARY, BUT ANY NUMBER OF EVALUATIONS 
C                  OF DUNI IN ANY ORDER, ARE ALLOWED.
C
C           NOTE: DEPENDING UPON THE VALUE OF K (SEE BELOW), THE OUTPUT
C                       OF DUNI MAY DIFFER FROM ONE MACHINE TO ANOTHER.
C
C           TYPICAL USAGE: 
C
C               DOUBLE PRECISION U,DUNI,DUSTAR,USEED
C               INTEGER ISEED 
CC                 SET SEED
C               ISEED = 305
C               USEED = DUSTAR(ISEED)
C               DO 1 I = 1,1000
C                   U = DUNI()
C             1 CONTINUE
CC                 NOTE: IF K=47 (THE DEFAULT, SEE BELOW) THE OUTPUT VALUE OF
CC                           U WILL BE 0.812053811384E-01...
C               WRITE(*,*) U
C               END 
C
C          NOTE ON PORTABILITY: USERS CAN CHOOSE TO RUN DUNI IN ITS DEFAULT
C               MODE (REQUIRING NO USER ACTION) WHICH WILL GENERATE THE SAME
C               SEQUENCE OF NUMBERS ON ANY COMPUTER SUPPORTING FLOATING POINT
C               NUMBERS WITH AT LEAST 47 BIT MANTISSAS, OR IN A MODE THAT
C               WILL GENERATE NUMBERS WITH A LONGER PERIOD ON COMPUTERS WITH
C               LARGER MANTISSAS.
C          TO EXERCISE THIS OPTION:  B E F O R E  INVOKING DUSTAR INSERT
C               THE INSTRUCTION        UBITS = DUNIB(K)      K >= 47
C               WHERE K IS THE NUMBER OF BITS IN THE MANTISSA OF YOUR FLOATING
C               POINT WORD (K=96 FOR CRAY, CYBER 205). DUNIB RETURNS THE
C               FLOATING POINT VALUE OF K THAT IT ACTUALLY USED.
C                    K INPUT AS .LE. 47, THEN UBITS=47.
C                    K INPUT AS .GT. 47, THEN UBITS=FLOAT(K)
C               IF K>47 THE SEQUENCE OF NUMBERS GENERATED BY DUNI MAY DIFFER
C               FROM ONE COMPUTER TO ANOTHER.
C
C
C
C***REFERENCES  MARSAGLIA G., "COMMENTS ON THE PERFECT UNIFORM RANDOM 
C                 NUMBER GENERATOR", UNPUBLISHED NOTES, WASH S. U.
C***ROUTINES CALLED  (NONE)
C***END PROLOGUE DUNI
      REAL*8 CSAVE,CD,CM,duni
      PARAMETER(
     *    CSAVE=0.9162596898123D+13/0.140737488355328D+15,
     *    CD=0.76543212345678D+14/0.140737488355328D+15,
     *    CM=0.140737488355213D+15/0.140737488355328D+15)
C                            2**47=0.140737488355328D+15
      REAL*8 U(17),S,T,DUSTAR,C,DUNIB
      INTEGER I,J,II,JJ,K,KK,I1,J1,K1,L1,M1,ISEED 
C
      SAVE U,I,J,K,C
C      LOAD DATA ARRAY IN CASE USER FORGETS TO INITIALIZE.
C      THIS ARRAY IS THE RESULT OF CALLING DUNI 100000 TIMES
C         WITH ISEED=305 AND K=96.
      DATA U/
     *0.471960981577884755837789724978D+00,
     *0.930323453205669578433639632431D+00,
     *0.110161790933730836587127944899D+00,
     *0.571501996273139518362638757010D-01,
     *0.402467554779738266237538503137D+00,
     *0.451181953427459489458279456915D+00,
     *0.296076152342721102174129954053D+00,
     *0.128202189325888116466879622359D-01,
     *0.314274693850973603980853259266D+00,
     *0.335521366752294932468163594171D-02,
     *0.488685045200439371607850367840D+00,
     *0.195470426865656758693860613516D+00,
     *0.864162706791773556901599326053D+00,
     *0.335505955815259203596381170316D+00,
     *0.377190200199058085469526470541D+00,
     *0.400780392114818314671676525916D+00,
     *0.374224214182207466262750307281D+00/
      DATA I,J,K,C/17,5,47,CSAVE/
C
C   BASIC GENERATOR IS FIBONACCI
C
      DUNI = U(I)-U(J)
      IF(DUNI.LT.0.0D0)DUNI = DUNI+1.0D0
      U(I) = DUNI
      I = I-1
      IF(I.EQ.0)I = 17
      J = J-1
      IF(J.EQ.0)J = 17
C
C   SECOND GENERATOR IS CONGRUENTIAL
C
      C = C-CD
      IF(C.LT.0.0D0) C=C+CM
C
C   COMBINATION GENERATOR
C
      DUNI = DUNI-C 
      IF(DUNI.LT.0.0D0)DUNI = DUNI+1.0D0
      RETURN
C
      ENTRY DUSTAR(ISEED)
C
C          SET UP ...
C          CONVERT ISEED TO FOUR SMALLISH POSITIVE INTEGERS.
C
        I1 = MOD(ABS(ISEED),177)+1
        J1 = MOD(ABS(ISEED),167)+1
        K1 = MOD(ABS(ISEED),157)+1
        L1 = MOD(ABS(ISEED),147)+1
C
C              GENERATE RANDOM BIT PATTERN IN ARRAY BASED ON GIVEN SEED.
C
        DO 2 II = 1,17
          S = 0.0D0 
          T = 0.5D0 
C             DO FOR EACH OF THE BITS OF MANTISSA OF WORD
C             LOOP  OVER K BITS, WHERE K IS DEFAULTED TO 47 BUT CAN
C               BE CHANGED BY USER CALL TO DUNIB(K)
          DO 3 JJ = 1,K
                  M1 = MOD(MOD(I1*J1,179)*K1,179) 
                  I1 = J1
                  J1 = K1
                  K1 = M1
                  L1 = MOD(53*L1+1,169) 
                  IF(MOD(L1*M1,64).GE.32)S=S+T
    3             T = 0.5D0*T 
    2   U(II) = S
        DUSTAR = FLOAT(ISEED) 
        RETURN
C
      ENTRY DUNIB(KK)
        IF(KK.LE.47)THEN
             K=47
        ELSE
             K=KK
        ENDIF
        DUNIB=FLOAT(K)
      END
