!======================================================================-
      function func(p) 
!======================================================================-

      implicit none
      integer nx,mparm,ng
      parameter (nx=5000,ng=10,mparm=3*ng-1)
!-->     arguments 
      real*8 p(*),func

!--->   local variables
      real*8 xfm(ng),xrm(ng),s2(ng),dist1,dist2,s1s(ng),dx,aux1
     &     ,aux2,df,wi(ng),zero,sumg,sumc,eps,dist,wm
      integer i,j

!-->     common block data 
      real*8 xf(-nx:nx),xr(-nx:nx),fdist(-nx:nx),rdist(-nx:nx)
      real*8 c_fdist(-nx:nx),c_rdist(-nx:nx),m_fdist(-nx:nx)
     &     ,m_rdist(-nx:nx),ci(ng),di(ng)
      real*8 frange0,frange,frange_12,beta,pi,funcfor,funcrev
      real*8 pmax(mparm),pmin(mparm)
      integer nparm,nc,ifunc,itype,ibeg,iend
      common /alldata/ xf,xr,fdist,rdist,c_fdist,c_rdist,beta,pi,pmax
     &     ,pmin,funcfor,funcrev,frange,frange0,frange_12,ci,di,ifunc
     &     ,itype,ibeg,iend,nparm,nc

      func=0.d0

!--------------------set parameters------------------------------------
      if(nc.gt.1) THEN
        DF=p(nparm)
      ELSE
        DF=xfm(1)-0.5*beta*s2(1)
      END IF
!     moments
      do i=1,nc
        xfm(i) = p(i)
        s2(i)  = dsqrt(p(nc+i)**2.)
        s1s(i) = dsqrt(1.d0/s2(i))
        xrm(i) = xfm(i)-beta*s2(i)
        zero = DF - (xfm(i)-0.5*beta*s2(i))
        if(zero.gt.999.d0) zero=200.d0
        wi(i) = dexp(beta*zero)  
      end do

      sumg=0.d0
      sumc=0.d0
!     forward coefficients
      do i=1,nc-2
        ci(i)=p(i+2*nc)
        sumg=sumg+ci(i)*(wi(i)-wi(nc))
        sumc=sumc+ci(i)
      end do
      if(nc.GT.1) THEN
        if(wi(nc-1).eq.wi(nc)) then
          ci(nc-1)=0.5*(1.d0-sumc)
        ELSE  
          ci(nc-1)= (1.d0 - (sumg + wi(nc)))/(wi(nc-1)-wi(nc))
        endif 
        sumc=sumc+ci(nc-1)
      end if
      ci(nc)=1.d0-sumc

!     reverse coefficient 
      wm=0.d0
      do i=1,nc
        di(i)=ci(i)*wi(i)
        wm=wm+ci(i)*xfm(i)   ! mean work
      end do

!--------check ranges ------------------------------------------

!     coeff range
      frange0=0.d0
      do i=1,nc
        if(ci(i).gt.1.d0) frange0=frange0+10.d0*ci(i)**2. 
        if(ci(i).lt.0.d0) frange0=frange0+10.d0*(1.d0-ci(i))**2. 
        if(di(i).gt.1.d0) frange0=frange0+10.d0*di(i)**2. 
        if(di(i).lt.0.d0) frange0=frange0+10.d0*(1.d0-di(i))**2. 
      END DO
!     free energy range
      aux2 = 1.d0/(pmax(nparm)-pmin(nparm))**2.
      frange_12=0.d0
      if(df.gt.pmax(nparm)) frange_12=frange_12+aux2*(df-pmax(nparm))**2
      if(df.lt.pmin(nparm)) frange_12=frange_12+aux2*(df-pmin(nparm))**2
      if(df.gt.wm) frange_12=frange_12+aux2*(df-wm)**2
c--   params range
      frange=0.d0
      aux1=0.d0
      do i=1,nparm-1
       aux2 = 1.d0/(pmax(i)-pmin(i))**2.
       if(p(i).gt.pmax(i)) 
     &      aux1 = aux2*(p(i)-pmax(i))**2
       if(p(i).lt.pmin(i)) 
     &      aux1 = aux2*(p(i)-pmin(i))**2.
       frange = frange + aux1
      end do
      func= func+ frange  + frange_12 + frange0

!-------------------------------------------------------------------
!     start forward and reverse func calculations
!-------------------------------------------------------------------

      funcfor=0.d0
!     start forward func calculation
      do i=ibeg,iend
        c_fdist(i)=0.d0
        do j=1,nc 
          dist  = pi*s1s(j)*exp(-(xf(i)-xfm(j))**2./(2.d0*s2(j))) 
          c_fdist(i) = c_fdist(i)+ci(j)*dist
        end do
        if(itype.ne.2) THEN 
          funcfor= funcfor+100.*(fdist(i)-c_fdist(i))**2.
        END IF
      end do 
      func = func + funcfor
!     start reverse func calculations
      funcrev=0.d0
      do i=ibeg,iend
        c_rdist(i)=0.d0
        do j=1,nc 
          dist  = pi*s1s(j)*exp(-(xf(i)-xrm(j))**2./(2.d0*s2(j))) 
          c_rdist(i) = c_rdist(i)+di(j)*dist
        end do
        if(itype.ne.1) THEN
          funcrev= funcrev+100.*(rdist(i)-c_rdist(i))**2.
       END IF
      end do 
      func = func + funcrev

      ifunc=ifunc+1
 
!      if(mod(ifunc,100).eq.0) THEN 
!        write(6,10) (p(i),i=1,nc)
!        write(6,11) (p(i),i=nc+1,2*nc)
!        write(6,14) (ci(i),i=1,nc)
!        write(6,17) (wi(i),i=1,nc)
!        write(6,15) (di(i),i=1,nc)
!        write(6,12) func,funcfor,funcrev
!        write(6,13) frange,frange0,frange_12
!10      format("mean  ",30G12.5)
!11      format("sigma ",30G12.5)
!14      format("ci    ",30G12.5)
!17      format("wi    ",30G12.5)
!15      format("di    ",30G12.5)
!12      format("FUNC   ",30G12.5)
!13      format("RABGES ",30G12.5)
!      END IF
      return
      end
