PROGRAM BENNETT

  IMPLICIT NONE

  INTEGER :: NF, NPA, J, N, I, NPATHS, NREALIZ, N_FORW, N_BACKW,ntimes,k

! NUMERO DI PUNTI NELLA CURVA PMF
  PARAMETER ( NF = 3000 )

  PARAMETER ( NPA = 3000 )

  REAL(8) :: R2, WRK, X, C, B, A, RGAS, TEMP, OFFSET,deltaz,rold,kost
  REAL(8) :: WRK_R, WRK_F, DF_AQ_J, DF_BQ_J, DF_AB,DFMA(100000)
  REAL(8) :: BETA, DF_AQ_EQ8, DF_AQ_EQ9, DF_AQ_EQ16, DF_AQ_MINH, DF_AQ_PMFB, DF_AQ_PMFA
  REAL(8) :: TIME(NF), W_F(NPA,NF), W_R(NPA,NF), R1(NPA,NF),DFIT(NF),zeta(NF),zf(npa,nf),zr(npa,nf)
  REAL, EXTERNAL :: FUNC2, FUNC8, FUNC9, FUNC16, FUNCA, FUNCB, ZBRENT, FUNC_MINH
  REAL :: TOL, X1, X2
  REAL(8) :: WRK_F_Aq(NPA), WRK_F_Ab(NPA), WRK_R_Bq(NPA), WRK_R_Ba(NPA)

  COMMON / COMM1 / WRK_F_Aq, WRK_F_Ab, WRK_R_Bq, WRK_R_Ba
  COMMON / COMM2 / BETA, DF_AB, N_FORW, N_BACKW
  COMMON /COMM3 / W_F,W_R,DFIT,zf,zr,zeta

! NUMERO MASSIMO DI REALIZZAZIONI

  call opens

! TEMPERATURA
  TEMP = 300.

! COSTANTE DEI GAS PERFETTI
  RGAS = 8.314472
  BETA = 1.D0 / ( RGAS / 1000.D0 * TEMP )


! NPATHS = NUMERO DI REALIZZAZIONI
  NPATHS = 1
  j=0
  read(*,*) kost
  kost=kost*4.184
  DO k = 1, 9000000
     j =j+1
     READ(2,*,END=100) R1(NPATHS,J), W_F(NPATHS,J),zf(npaths,j) 
     zeta(j)=R1(1,j)
     if(j.gt.1) THEN 
        if(R1(NPATHS,J).LT.R1(NPATHS,J-1)) THEN 
           ntimes=j-1
           j=0
           npaths=npaths+1
        endif
     endif
  ENDDO
100  write(*,*) npaths,ntimes
  deltaz=zeta(2)-zeta(1)
  r2=100.0
  NPATHS = 1
  j=0
  DO k = 1, 9000000
     j =j+1
     rold=r2
     READ(3,*,END=200) R2, W_R(NPATHS,J),zr(npaths,j) 
     if(j.gt.1) THEN 
        if(R2.GT.rold) THEN 
           ntimes=j-1
           j=0
           npaths=npaths+1
        endif
     endif
  ENDDO

 200 write(*,*) npaths,ntimes
  DO I = 1, NPATHS
     WRK_F_Ab(I) = W_F(I,ntimes)
     WRK_R_Ba(I) = W_R(I,ntimes)
  ENDDO


  N_FORW = NPATHS
  N_BACKW = NPATHS


  X1 = -300.
  X2 = 300.
  TOL = 1.E-9

! DF_AB  (Eq. 2 PRE)
  DF_AB = ZBRENT( FUNC2, X1, X2, TOL )

  WRITE(*,'(A)') '#  posizione,  DF_AQ_EQ8,  DF_AQ_EQ9, DF_AQ_EQ16, DF_AQ_MINH, DF_AQ_PMFA,    DF_AQ_J,    DF_BQ_J'

  DO J = 1, Ntimes

     DO I = 1, NPATHS
        WRK_F_Aq(I) = W_F( I, J )
        WRK_R_Bq(I) = W_R( I, Ntimes + 1 - J )
     ENDDO

! DF calcolato con Jarzynski nell direzione R
     WRK_R = 0.
     DO N = 1, N_BACKW
        WRK_R = WRK_R + DEXP( - BETA * WRK_R_Bq(N) )
     ENDDO
     DF_BQ_J = - DLOG( WRK_R / DBLE(N_BACKW) ) / BETA

! DF calcolato con Jarzynski nell direzione F
     WRK_F = 0.
     DO N = 1, N_FORW
        WRK_F = WRK_F + DEXP( - BETA * WRK_F_Aq(N) )
     ENDDO
     DF_AQ_J = - DLOG( WRK_F / DBLE(N_FORW) ) / BETA

! Eq. 8 PRE
     DF_AQ_EQ8 = ZBRENT( FUNC8, X1, X2, TOL )


! Eq. 9 PRE
     DF_AQ_EQ9 = ZBRENT( FUNC9, X1, X2, TOL )


! Eq. 16 PRE
     DF_AQ_EQ16 = ZBRENT( FUNC16, X1, X2, TOL )


! Calcolo metodo Minh
     DF_AQ_MINH = FUNC_MINH()
!--  store away value for Hummer-Szabo reweighting
     DFIT(J)=DF_AQ_MINH

! Eq. PMFA
     A = EXP( -BETA * DF_AQ_J )
     B = EXP( -BETA * DF_AB )
     C = EXP( -BETA * DF_BQ_J )
     X = 2.D0 / ( A + B * C )
     DF_AQ_PMFA = DLOG ( X ) / BETA

     IF ( J == 1 ) THEN
        OFFSET = DF_AQ_PMFA
     ENDIF

     DF_AQ_PMFA = DF_AQ_PMFA - OFFSET


! Eq. PMFB
!     DF_AQ_PMFB = ZBRENT( FUNCB, X1, X2, TOL )

     WRITE(*,'(F15.7,8F12.4,10G20.10)') R1(1,J), DF_AQ_EQ8, DF_AQ_EQ9, DF_AQ_EQ16, DF_AQ_MINH, DF_AQ_PMFA, DF_AQ_J, DF_BQ_J

  ENDDO
  write(*,*) " HUMMER AND SZABO REWEIGHTING ON MINH ADIX ESTIMATES in FORT.8" 
  CALL MINH2(DFMA,deltaz,kost,ntimes)
  STOP
END PROGRAM BENNETT





!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
FUNCTION FUNC2 ( DEF )

  IMPLICIT NONE

  INTEGER :: NPA, NF, NR, N

  PARAMETER ( NPA = 3000 )

  REAL :: FUNC2, DEF
  REAL(8) :: F1, F2, M, BETA, DF_AB
  REAL(8) :: WRK_F_Aq(NPA), WRK_F_Ab(NPA), WRK_R_Bq(NPA), WRK_R_Ba(NPA)
  INTEGER :: N_FORW, N_BACKW

  COMMON / COMM1 / WRK_F_Aq, WRK_F_Ab, WRK_R_Bq, WRK_R_Ba
  COMMON / COMM2 / BETA, DF_AB, N_FORW, N_BACKW


  NR = N_BACKW
  NF = N_FORW

  M = DLOG ( DBLE(NF) / DBLE(NR) ) / BETA

  F1 = 0.D0
  F2 = 0.D0

  DO N = 1, NF
     F1 = F1 + 1.D0 / ( 1.D0 + DEXP ( BETA * ( M + WRK_F_Ab(N) - DEF ) ) )
  ENDDO

  DO N = 1, NR
     F2 = F2 - 1.D0 / ( 1.D0 + DEXP( BETA * ( - M + WRK_R_Ba(N) + DEF ) ) )
  ENDDO

  FUNC2 = F1 + F2

  RETURN
END FUNCTION FUNC2


!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
FUNCTION FUNC_MINH

  IMPLICIT NONE

  INTEGER :: NPA, NF, NR, N

  PARAMETER ( NPA = 3000 )

  REAL :: FUNC_MINH
  REAL(8) :: F1, F2, BETA, DF_AB
  REAL(8) :: WRK_F_Aq(NPA), WRK_F_Ab(NPA), WRK_R_Bq(NPA), WRK_R_Ba(NPA)
  INTEGER :: N_FORW, N_BACKW

  COMMON / COMM1 / WRK_F_Aq, WRK_F_Ab, WRK_R_Bq, WRK_R_Ba
  COMMON / COMM2 / BETA, DF_AB, N_FORW, N_BACKW


  NR = N_BACKW
  NF = N_FORW

  F1 = 0.D0
  F2 = 0.D0

  DO N = 1, NF
     F1 = F1 + DEXP( -BETA * WRK_F_Aq(N) ) / ( DBLE(NF) + DBLE(NR) * DEXP( -BETA * ( WRK_F_Ab(N) - DF_AB ) ) )
  ENDDO

  DO N = 1, NR
     F2 = F2 + DEXP( -BETA * ( WRK_R_Bq(N) - WRK_R_Ba(N) ) ) / ( DBLE(NF) + DBLE(NR) * DEXP( BETA * ( WRK_R_Ba(N) + DF_AB ) ) )
  ENDDO

  FUNC_MINH = -DLOG( F1 + F2 ) / BETA

  RETURN
END FUNCTION FUNC_MINH



!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
SUBROUTINE MINH2(DFMA,deltaz,kost,ntimes)

  IMPLICIT NONE

  INTEGER :: NPA, NF, NR, N,ntimes,k,jt,imax,imin,ibinmin,ibinmax,NT
  REAL(8) :: KOST 
  PARAMETER ( NPA = 3000, NT=3000)
  REAL :: FUNC_MINH,norm
  REAL(8) :: F1(100000), F2(100000), BETA, DF_AB,DFMA(100000),deltaz,gz(100000),vz(100000)
  REAL(8) :: WRK_F_Aq(NPA), WRK_F_Ab(NPA), WRK_R_Bq(NPA), WRK_R_Ba(NPA),zf(NPA,nt),zr(npa,nt)
  REAL(8) :: W_F(NPA,NT), W_R(NPA,NT),DFIT(NT),BNORM(100000),NROM,zeta(nt),dfmamin
  INTEGER :: N_FORW, N_BACKW,IT,izbin

  COMMON / COMM1 / WRK_F_Aq, WRK_F_Ab, WRK_R_Bq, WRK_R_Ba
  COMMON / COMM2 / BETA, DF_AB, N_FORW, N_BACKW
  COMMON / COMM3 / W_F,W_R,DFIT,zf,zr,zeta

  NR = N_BACKW
  NF = N_FORW

  F1 = 0.D0
  F2 = 0.D0

  norm=1.d0/dfloat(ntimes) ! normalization for rho(z)= delta(z-z_t) such that \int rho(z)dz =1  

! computes normalization factor at the denominator of Eq. 1- of Minh Adib PRL. 

  bnorm=0.d0  
  
  do it=1,ntimes
     izbin=zeta(it)/deltaz
     do jt=1,ntimes
        bnorm(izbin)=bnorm(izbin)+ dexp(-beta*(Kost*(zeta(it)-zeta(jt))**2 - DFIT(jt)))
     end do
  end do
! loop on trajectories 
  imax=0
  imin=100000
  DO N = 1, NF
!    set to zero g(z) function on all z range
     gz=0.d0
!    computes for forward traj i the values of g(z) for ALL zetas     
     ibinmax=0
     ibinmin=100000
     DO IT=1,NTIMES
        izbin=1+int(zf(N,it)/deltaz) 
        if(izbin.gt.ibinmax) ibinmax=izbin
        if(izbin.lt.ibinmin) ibinmin=izbin
        GZ(izbin) = GZ(izbin) + DEXP(BETA*(DFIT(IT)-W_F(N,IT)))  
     end do
     if(ibinmax.gt.imax) imax=ibinmax
!    sum up trajectories on all zeta range
     Do it=ibinmin,ibinmax
        F1(it) = F1(it) + Gz(it) / ( DBLE(NF) + DBLE(NR) * DEXP( -BETA * ( WRK_F_Ab(N) - DF_AB ) ) )
!        write(8,*) N,it,zeta(it),gz(it),zf(n,it),F1(it)
     end do
!     write(8,*) n,ibinmin,ibinmax,F1(ibinmin),F1(ibinmax)
  ENDDO

  DO N = 1, NR
!    set to zero v(z) function on all z range
     vz = 0.d0 
!    computes for reverse traj i the values of v(z) for ALL zetas     g
     ibinmax=0
     ibinmin=100000
     DO IT=1,NTIMES
        izbin=1+int(zr(N,ntimes+1-it)/deltaz)
        if(izbin.gt.ibinmax) ibinmax=izbin
        if(izbin.lt.ibinmin) ibinmin=izbin
!         vZ(izbin) = vZ(izbin) + DEXP(BETA*(DFIT(IT)+W_R(N,IT)))  
!        Simone
!         vZ(izbin) = vZ(izbin) + DEXP(BETA*(DFIT(ntimes+1-IT)+W_R(N,ntimes+1-IT)))  
!        Riccardo
        vZ(izbin) = vZ(izbin) + DEXP(BETA*(DFIT(IT)-(W_R(N,ntimes+1-IT) - W_R(N,ntimes) )))  
     end do
     if(ibinmin.lt.imin) imin=ibinmin
!    sum up trajectories on all zeta rangeg
     do it=ibinmin,ibinmax
        F2(it) = F2(it) + Vz(it) / ( DBLE(NF) + DBLE(NR) * DEXP( BETA * ( WRK_R_Ba(N) + DF_AB ) ) ) 
     end do
!     write(8,*) n,ibinmin,ibinmax
  ENDDO
 DFMA=0.d0
 dfmamin=10000.d0
  do it=imin,imax
     if((F1(it)+F2(it)).gt.1.d-10.and.bnorm(it).gt.1.d-10) THEN 
        DFMA(it) = -DLOG( (F1(it) + F2(it))/bnorm(it) ) / BETA
        if(dfma(it).lt.dfmamin) dfmamin=dfma(it)
     ENDIF
     write(8,*) it,it*deltaz,f1(it),f2(it),bnorm(it),dfma(it),deltaz
  end do
  do it=imin,imax
     if((F1(it)+F2(it)).gt.1.d-10.and.bnorm(it).gt.1.d-10) THEN 
        DFMA(it) = DFMA(it)-dfmamin
        write(4,*) it*deltaz,dfma(it)
     ENDIF
  END DO
  RETURN
END SUBROUTINE MINH2


!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
FUNCTION FUNC8 ( DF_AQ )

  IMPLICIT NONE

  INTEGER :: NPA, NF, NR, N

  PARAMETER ( NPA = 3000 )

  REAL :: FUNC8, DF_AQ
  REAL(8) :: F1, F2, WRK_R, M, BETA, DF_AB, WRK_R_qa
  REAL(8) :: WRK_F_Aq(NPA), WRK_F_Ab(NPA), WRK_R_Bq(NPA), WRK_R_Ba(NPA)
  INTEGER :: N_FORW, N_BACKW

  COMMON / COMM1 / WRK_F_Aq, WRK_F_Ab, WRK_R_Bq, WRK_R_Ba
  COMMON / COMM2 / BETA, DF_AB, N_FORW, N_BACKW


  NR = N_BACKW
  NF = N_FORW

  WRK_R = 0.
  DO N = 1, NR
     WRK_R = WRK_R + DEXP( - BETA * WRK_R_Bq(N) )
  ENDDO
  WRK_R = WRK_R / DBLE(NR)


  M = DLOG ( DBLE(NF) / DBLE(NR) ) / BETA

  F1 = 0.D0
  F2 = 0.D0

  DO N = 1, NF
     F1 = F1 + 1.D0 / ( 1.D0 + DEXP ( BETA * ( M + WRK_F_Aq(N) - DF_AQ ) ) )
  ENDDO

  DO N = 1, NR
     WRK_R_qa = WRK_R_Ba(N) - WRK_R_Bq(N)
     F2 = F2 - DEXP( - BETA * WRK_R_Bq(N) ) / ( 1.D0 + DEXP( BETA * ( - M + WRK_R_qa + DF_AQ ) ) ) / WRK_R
  ENDDO

  FUNC8 = F1 + F2

  RETURN
END FUNCTION FUNC8




!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
FUNCTION FUNC9 ( DF_AQ )

  IMPLICIT NONE

  INTEGER :: NPA, NF, NR, N

  PARAMETER ( NPA = 3000 )

  REAL :: FUNC9, DF_AQ
  REAL(8) :: F1, F2, WRK_F, M, BETA, DF_AB, DF_QB, WRK_F_qb
  REAL(8) :: WRK_F_Aq(NPA), WRK_F_Ab(NPA), WRK_R_Bq(NPA), WRK_R_Ba(NPA)
  INTEGER :: N_FORW, N_BACKW

  COMMON / COMM1 / WRK_F_Aq, WRK_F_Ab, WRK_R_Bq, WRK_R_Ba
  COMMON / COMM2 / BETA, DF_AB, N_FORW, N_BACKW


  NR = N_BACKW
  NF = N_FORW

  DF_QB = DF_AB - DF_AQ

  WRK_F = 0.D0
  DO N = 1, NF
     WRK_F = WRK_F + DEXP( - BETA * WRK_F_Aq(N) )
  ENDDO
  WRK_F = WRK_F / DBLE(NF)

  M = DLOG ( DBLE(NF) / DBLE(NR) ) / BETA

  F1 = 0.D0
  F2 = 0.D0

  DO N = 1, NF
     WRK_F_qb = WRK_F_Ab(N) - WRK_F_Aq(N)
     F1 = F1 + DEXP( - BETA * WRK_F_Aq(N) ) / ( 1.D0 + DEXP ( BETA * ( M + WRK_F_qb - DF_QB ) ) ) / WRK_F
  ENDDO

  DO N = 1, NR
     F2 = F2 - 1.D0 / ( 1.D0 + DEXP( BETA * ( - M + WRK_R_Bq(N) + DF_QB ) ) )
  ENDDO

  FUNC9 = F1 + F2

  RETURN
END FUNCTION FUNC9



!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
FUNCTION FUNC16 ( DF_AQ )

  IMPLICIT NONE

  INTEGER :: NPA, NF, NR, N

  PARAMETER ( NPA = 3000 )

  REAL :: FUNC16, DF_AQ
  REAL(8) :: F1, F2, F3, F4, WRK_F, WRK_R, M, BETA, DF_AB, WRK_F_qb, WRK_R_qa
  REAL(8) :: WRK_F_Aq(NPA), WRK_F_Ab(NPA), WRK_R_Bq(NPA), WRK_R_Ba(NPA)
  INTEGER :: N_FORW, N_BACKW

  COMMON / COMM1 / WRK_F_Aq, WRK_F_Ab, WRK_R_Bq, WRK_R_Ba
  COMMON / COMM2 / BETA, DF_AB, N_FORW, N_BACKW


  NR = N_BACKW
  NF = N_FORW

  WRK_R = 0.
  DO N = 1, NR
     WRK_R = WRK_R + DEXP( - BETA * WRK_R_Bq(N) )
  ENDDO
  WRK_R = WRK_R / DBLE(NR)

  M = DLOG ( DBLE(NF) / DBLE(NR) ) / BETA

  F1 = 0.D0
  F2 = 0.D0

  DO N = 1, NF
     F1 = F1 + 1.D0 / ( 1.D0 + DEXP ( BETA * ( M + WRK_F_Aq(N) - DF_AQ ) ) )
  ENDDO

  DO N = 1, NR
     WRK_R_qa = WRK_R_Ba(N) - WRK_R_Bq(N)
     F2 = F2 - DEXP( - BETA * WRK_R_Bq(N) ) / ( 1.D0 + DEXP( BETA * ( - M + WRK_R_qa + DF_AQ ) ) ) / WRK_R
  ENDDO



  WRK_F = 0.D0
  DO N = 1, NF
     WRK_F = WRK_F + DEXP( - BETA * WRK_F_Aq(N) )
  ENDDO
  WRK_F = WRK_F / DBLE(NF)

  M = DLOG ( DBLE(NF) / DBLE(NR) ) / BETA

  F3 = 0.D0
  F4 = 0.D0

  DO N = 1, NF
     WRK_F_qb = WRK_F_Ab(N) - WRK_F_Aq(N)
     F3 = F3 - DEXP( - BETA * WRK_F_Aq(N) ) / ( 1.D0 + DEXP( BETA * ( M + WRK_F_qb - DF_AB + DF_AQ ) ) ) / WRK_F
  ENDDO

  DO N = 1, NR
     F4 = F4 + 1.D0 / ( 1.D0 + DEXP( BETA * ( - M + WRK_R_Bq(N) + DF_AB - DF_AQ ) ) )
  ENDDO

  FUNC16 = F1 + F2 + F3 + F4

  RETURN
END FUNCTION FUNC16



!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
FUNCTION FUNCB ( DF_AQ )

  IMPLICIT NONE

  INTEGER :: NPA, NF, NR, N

  PARAMETER ( NPA = 3000 )

  REAL :: FUNCB, DF_AQ
  REAL(8) :: F1, F2, BETA, DF_AB, WRK_F_qb, WRK_R_qa
  REAL(8) :: WRK_F_Aq(NPA), WRK_F_Ab(NPA), WRK_R_Bq(NPA), WRK_R_Ba(NPA)
  INTEGER :: N_FORW, N_BACKW

  COMMON / COMM1 / WRK_F_Aq, WRK_F_Ab, WRK_R_Bq, WRK_R_Ba
  COMMON / COMM2 / BETA, DF_AB, N_FORW, N_BACKW


  NR = N_BACKW
  NF = N_FORW

  F1 = 0.D0
  F2 = 0.D0

  DO N = 1, NF
     F1 = F1 + 1.D0 / ( 1.D0 + NF * DEXP ( BETA * ( WRK_F_Aq(N) - DF_AQ ) ) )
  ENDDO

  DO N = 1, NR
     F2 = F2 + 1.D0 / ( 1.D0 + NR * DEXP( BETA * ( WRK_R_Bq(N) + DF_AB - DF_AQ ) ) )
  ENDDO

  FUNCB = F1 + F2 - 2.D0

  RETURN
END FUNCTION FUNCB



!===========================================================
FUNCTION ZBRENT( FUNC, X1, X2, TOL )                                           

  PARAMETER (ITMAX=100,EPS=3.E-8)                                           

  A=X1                                                                      
  B=X2                                                                      
  FA=FUNC(A)                                                                
  FB=FUNC(B)                                                                

  IF(FB*FA.GT.0.) THEN
     WRITE(*,*) A, B, FA, FB
     PAUSE 'Root must be bracketed for ZBRENT.'                
  ENDIF
  FC=FB                                                                     
  DO ITER=1,ITMAX                                                        
     IF(FB*FC.GT.0.) THEN                                                    
        C=A                                                                   
        FC=FA                                                                 
        D=B-A                                                                 
        E=D                                                                   
     ENDIF
     IF(ABS(FC).LT.ABS(FB)) THEN                                             
        A=B                                                                   
        B=C                                                                   
        C=A                                                                   
        FA=FB                                                                 
        FB=FC                                                                 
        FC=FA                                                                 
     ENDIF
     TOL1=2.*EPS*ABS(B)+0.5*TOL                                              
     XM=.5*(C-B)                                                             
     IF(ABS(XM).LE.TOL1 .OR. FB.EQ.0.)THEN                                   
        ZBRENT=B                                                              
        RETURN                                                                
     ENDIF
     IF(ABS(E).GE.TOL1 .AND. ABS(FA).GT.ABS(FB)) THEN                        
        S=FB/FA                                                               
        IF(A.EQ.C) THEN                                                       
           P=2.*XM*S                                                           
           Q=1.-S                                                              
        ELSE                                                                  
           Q=FA/FC                                                             
           R=FB/FC                                                             
           P=S*(2.*XM*Q*(Q-R)-(B-A)*(R-1.))                                    
           Q=(Q-1.)*(R-1.)*(S-1.)                                              
        ENDIF
        IF(P.GT.0.) Q=-Q                                                      
        P=ABS(P)                                                              
        IF(2.*P .LT. MIN(3.*XM*Q-ABS(TOL1*Q),ABS(E*Q))) THEN                  
           E=D                                                                 
           D=P/Q                                                               
        ELSE                                                                  
           D=XM                                                                
           E=D                                                                 
        ENDIF
     ELSE                                                                    
        D=XM                                                                  
        E=D                                                                   
     ENDIF
     A=B                                                                     
     FA=FB                                                                   
     IF(ABS(D) .GT. TOL1) THEN                                               
        B=B+D                                                                 
     ELSE                                                                    
        B=B+SIGN(TOL1,XM)                                                     
     ENDIF
     FB=FUNC(B)                                                              
  ENDDO
  PAUSE 'ZBRENT exceeding maximum iterations.'                              
  ZBRENT=B                                                                  

  RETURN                                                                    
END FUNCTION ZBRENT
 SUBROUTINE OPENS 
!  Opens parms passed to command as unis 7, 8, ...
      PARAMETER( MAXLEN = 80 )
      CHARACTER*80 STRING
      N = 1
1     N = N + 1
      CALL GETPRM( N-1, STRING, LENGHT )
      IF( LENGHT .EQ. 0) RETURN
      WRITE(*,*) ' Fortran unit ', N, ' ', STRING(1:LENGHT)
      OPEN( UNIT=N, FILE=STRING(1:LENGHT),STATUS='UNKNOWN' )
      REWIND( N )
      GOTO 1
      END

      SUBROUTINE BLSTRIP( STRING, LENGHT )
!  Strip trailing blanks from STRING, returns LENGTH
      PARAMETER( MAXLEN = 80 )
      CHARACTER*80 STRING
      
      LENGHT = MAXLEN+1
1     LENGHT = LENGHT - 1
      IF( LENGHT .EQ. 0 ) RETURN
      IF( STRING(LENGHT:LENGHT) .EQ. ' ' ) GOTO 1

      RETURN
      END

      SUBROUTINE GETPRM( N, STRING, LENGHT )
!  Returns N-th parameter on the command line (if LENGHT .gt. 0)
      PARAMETER( MAXLEN = 80 )
      CHARACTER*80 STRING

      CALL GETARG( N, STRING )
      CALL BLSTRIP( STRING, LENGHT )

      RETURN
      END
