  PROGRAM BENNETT

  IMPLICIT NONE

  INTEGER :: MF, MR, NR, NF, J, N

  PARAMETER ( MF = 500000 )
  PARAMETER ( MR = 500000 )

  REAL :: NFR, TOL, X1, X2, X1A, X2A
  REAL(8) :: R1, R2, WRK1, WRK2, TEMP
  REAL(8) :: WRK_R, WRK_F, FFF, VAR_AQ, VAR_QB, VAR, A, DF, DF_BA_JR, DF_EQ16
  REAL(8) :: F1, F2, BETA, RGAS, DF_F_JARZY, DF_R_JARZY
  REAL(8) :: DF_AQ, DF_AB, DF_QB, DF_OLD, M, SIGMA2, DSIGMA2, FISHER, DFISHER
  REAL, EXTERNAL :: FUNC2, FUNC8, FUNC9, FUNC16, FUNC16B, ZBRENT

  REAL(8) :: WRK_F_Aq(MF), WRK_F_Ab(MF), WRK_R_Bq(MR), WRK_R_Ba(MR)

  COMMON / COMM1 / WRK_F_Aq, WRK_F_Ab, WRK_R_Bq, WRK_R_Ba
  COMMON / COMM2 / BETA, DF_AB, DSIGMA2, SIGMA2, NR, NF



! UNIT 10 ---&gt; forward work
! UNIT 11 ---&gt; backward work

! normal
  OPEN(10,FILE="works_forward",FORM='FORMATTED')
  OPEN(11,FILE="works_reverse",FORM='FORMATTED')

! temperature
  TEMP = 300.

! costante dei gas perfetti [ kJ/(mol K) ]
  RGAS = 8.314472 / 1000.

  BETA = 1. / ( RGAS * TEMP )


  DO j=1,MF 
     READ(10,*,end=101) WRK1
     WRK_F_Ab(J) = WRK1
  END DO
101 NF=j-1

  DO J = 1, MR
     READ(11,*,end=201) WRK1
     WRK_R_Ba(J) = WRK1
  ENDDO
201 NR=j-1 
  CLOSE(UNIT=10)
  CLOSE(UNIT=11)

  X1 = -1000.
  X2 = 1000.
  TOL = 1.E-9

! DF_AB  (Eq. 2 PRE)
  DF_AB = ZBRENT( FUNC2, X1, X2, TOL )

  write(6,*) "FREE ENERGY  ----> FB - FA", DF_AB

  STOP
END PROGRAM BENNETT


!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
FUNCTION FUNC2 ( DEF)

  IMPLICIT NONE

  INTEGER :: MF,MR,NF, NR, N

  PARAMETER ( MF = 500000 )
  PARAMETER ( MR = 500000 )

  REAL :: FUNC2, DEF
  REAL(8) :: F1, F2, M, BETA, DSIGMA2, SIGMA2, DF_AB
  REAL(8) :: WRK_F_Aq(MF), WRK_F_Ab(MF), WRK_R_Bq(MR), WRK_R_Ba(MR)

  COMMON / COMM1 / WRK_F_Aq, WRK_F_Ab, WRK_R_Bq, WRK_R_Ba
  COMMON / COMM2 / BETA, DF_AB, DSIGMA2, SIGMA2, NR, NF


  M = DLOG ( DBLE(NF) / DBLE(NR) ) / BETA

  F1 = 0.D0
  F2 = 0.D0

  DO N = 1, NF
     F1 = F1 + 1.D0 / ( 1.D0 + DEXP ( BETA * ( M + WRK_F_Ab(N) - DEF ) ) )
  ENDDO

  DO N = 1, NR
     F2 = F2 - 1.D0 / ( 1.D0 + DEXP( BETA * ( - M + WRK_R_Ba(N) + DEF ) ) )
  ENDDO

  FUNC2 = F1 + F2

  RETURN
END FUNCTION FUNC2



!===========================================================
FUNCTION ZBRENT( FUNC, X1, X2, TOL )                                           

  PARAMETER (ITMAX=100,EPS=3.E-8)                                           

  A=X1                                                                      
  B=X2                                                                      
  FA=FUNC(A)                                                                
  FB=FUNC(B)                                                                

  IF(FB*FA.GT.0.) THEN
     WRITE(*,*) A, B, FA, FB
     PAUSE 'Root must be bracketed for ZBRENT.'                
  ENDIF
  FC=FB                                                                     
  DO ITER=1,ITMAX                                                        
     IF(FB*FC.GT.0.) THEN                                                    
        C=A                                                                   
        FC=FA                                                                 
        D=B-A                                                                 
        E=D                                                                   
     ENDIF
     IF(ABS(FC).LT.ABS(FB)) THEN                                             
        A=B                                                                   
        B=C                                                                   
        C=A                                                                   
        FA=FB                                                                 
        FB=FC                                                                 
        FC=FA                                                                 
     ENDIF
     TOL1=2.*EPS*ABS(B)+0.5*TOL                                              
     XM=.5*(C-B)                                                             
     IF(ABS(XM).LE.TOL1 .OR. FB.EQ.0.)THEN                                   
        ZBRENT=B                                                              
        RETURN                                                                
     ENDIF
     IF(ABS(E).GE.TOL1 .AND. ABS(FA).GT.ABS(FB)) THEN                        
        S=FB/FA                                                               
        IF(A.EQ.C) THEN                                                       
           P=2.*XM*S                                                           
           Q=1.-S                                                              
        ELSE                                                                  
           Q=FA/FC                                                             
           R=FB/FC                                                             
           P=S*(2.*XM*Q*(Q-R)-(B-A)*(R-1.))                                    
           Q=(Q-1.)*(R-1.)*(S-1.)                                              
        ENDIF
        IF(P.GT.0.) Q=-Q                                                      
        P=ABS(P)                                                              
        IF(2.*P .LT. MIN(3.*XM*Q-ABS(TOL1*Q),ABS(E*Q))) THEN                  
           E=D                                                                 
           D=P/Q                                                               
        ELSE                                                                  
           D=XM                                                                
           E=D                                                                 
        ENDIF
     ELSE                                                                    
        D=XM                                                                  
        E=D                                                                   
     ENDIF
     A=B                                                                     
     FA=FB                                                                   
     IF(ABS(D) .GT. TOL1) THEN                                               
        B=B+D                                                                 
     ELSE                                                                    
        B=B+SIGN(TOL1,XM)                                                     
     ENDIF
     FB=FUNC(B)                                                              
  ENDDO
  PAUSE 'ZBRENT exceeding maximum iterations.'                              
  ZBRENT=B                                                                  

  RETURN                                                                    
END FUNCTION ZBRENT
