module pdb
  use precision
  use units
  type :: label ! define new type label
     character*6 :: recrd
     integer(ki) :: serial
     character*4 :: name
     character*1 :: altloc
     character*3 :: resname
     character*1 :: chainid
     integer(ki) :: resseq
     character*1 :: icode
  end type label
  
contains
  
  subroutine open_pdb(unit_number,file_name,file_status,nato)
    ! open unit unit_number connected to the pdb file file_name
    ! count the number of atoms in the pdb 
    implicit none
    integer, intent(out) :: unit_number
    integer, intent(out) :: nato
    character*(*), intent(in) :: file_name
    character*3, intent(in) :: file_status
    integer :: err
    character*80 :: line
    
    unit_counter = unit_counter + 1
    
    unit_number = unit_counter
    
    select case(file_status)
    case("OLD")
       open(unit=unit_number,file=file_name,status='OLD',iostat=err)
       if(err /= 0) then 
          write(0,*) "error opening unit ", unit_number, "pdbfile ", file_name
          stop
       end if
       nato = 0
       read_loop: do 
          read(unit_number,'(A80)',iostat=err) line
          if(err < 0) exit read_loop
          select case(line(1:6))
          case("ATOM  ","HETATM") 
             nato = nato + 1
          case("END   ","TER   ","ENDMDL") 
             exit  read_loop
          case default 
             cycle read_loop
          end select
       enddo read_loop
       rewind(unit_number)
    case("NEW")
       open(unit=unit_number,file=file_name,status='NEW',iostat=err)
    case("REP")
       open(unit=unit_number,file=file_name,status='REPLACE',iostat=err)
    case("SCR")
       open(unit=unit_number,status='SCRATCH',iostat=err)
    case("UNK")
       open(unit=unit_number,file=file_name,status='UNKNOWN',iostat=err)
    end select
    
    if(nato == 0) then 
       write(0,*) "file ",file_name,"contains 0 atoms"
       stop
    end if
    
  end subroutine open_pdb
  
  
  subroutine read_pdb(nato,file,r,pdblabel,endofpdb)
    implicit none
    integer,intent(in)     :: nato         ! number of atoms
    integer,intent(in)     :: file         ! pdb unit
    real(kr),intent(out)   :: r(3,*)       ! coordinates matrix
    type(label),intent(out):: pdblabel(*)  ! pdb label array
    logical,intent(out)    :: endofpdb          ! endofpdb
    ! local variables
    integer :: n            ! number of atoms
    integer(ki)            :: i,j
    integer(ki)            :: err       
    character*80           :: line
    real(kr) :: co(3,3)

    endofpdb = .false.
    n = 0
    read_loop: do        
       read(file,'(A80)',iostat=err) line
       if(err < 0) then 
          endofpdb = .true.
          exit read_loop
       end if
       select case(line(1:3))
       case("REM") 
          read(line,2,iostat=err) co(3,3) 
       case("ATO","HET") 
          n=n+1
          read(line,1,iostat=err) pdblabel(n),(r(j,n),j=1,3)
          if(err > 0) then 
             write(0,*) 'error while reading line ',n,'of unit',file
             stop
          end if
          pdblabel(n)%name = adjustl(pdblabel(n)%name)
       case("END","TER")  
          if(n == 0) cycle read_loop
          exit  read_loop
       case default 
          cycle read_loop
       end select
    enddo read_loop
    
1   format(a6,i5,1x,a4,a1,a3,1x,a1,i4,a1,3x,3f8.3,2f6.2)
2   format(42x,9f10.5)
    
  end subroutine read_pdb

  subroutine print_pdb(file,r,n,pdblabel)
    implicit none
    integer,intent(in)     :: file         ! pdb unit
    real(kr),intent(in)    :: r(3,*)       ! coordinates matrix
    integer,intent(in)     :: n            ! number of atoms
    type(label),intent(in) :: pdblabel(*)  ! pdb label array
    ! local variables
    integer(ki)            :: i,j
    integer(ki)            :: err       

    do i = 1,n
       write(file,1) pdblabel(i), (r(j,i),j=1,3)
    end do
    write(file,'(a3)') 'END'
    
1   format(a6,i5,1x,a4,a1,a3,1x,a1,i4,a1,3x,3f8.3,2f6.2)
    
  end subroutine print_pdb


end module pdb

  
  
  
