module output
  use precision
  use units
  implicit none
  integer(ki), allocatable :: kout(:) ! output units array
  character*64, allocatable :: fout(:) ! output file names array
  
contains
  
  subroutine allocate_out(ncv)
    implicit none
    integer(ki), intent(in) :: ncv
    ! local variables
    integer(ki) :: err
    
    allocate(kout(ncv),fout(ncv),stat=err)
    
    if(err /= 0) then 
       write(0,*) 'error while allocating memory (kout,fout)'
       stop
    end if
    
  end subroutine allocate_out
  
  subroutine open_out(ncv,name)
    implicit none
    integer(ki), intent(in) :: ncv
    character*64, intent(in) :: name(ncv)
    ! local variables
    integer(ki) :: i
    character*64 :: nam,nn
    
    do i = 1,ncv
       write(nn,'(a1,i2.2)') '.',i
       nam = trim(name(i))//trim(nn)//'.out'
       call openf(kout(i),nam,'UNK')
    end do
    
  end subroutine open_out

  subroutine print_out(i,val,num)
    ! print out a line of output for the i-th cv
    implicit none
    integer(ki), intent(in) :: i
    real(kr), intent(in) :: val(:)
    integer(ki), intent(in) :: num
    ! local variables
    character*64 :: frm
    
    write(frm,'(a1,i1,a10,a1)') '(',num,'(f8.3,1x))'
    write(kout(i),frm) val(1:num)
    
  end subroutine print_out
  
end module output
