module input
  use precision
  implicit none
  
contains
  
  subroutine count_cv(ncv)
    ! count the number of cvs in input
    implicit none
    integer(ki), intent(out) :: ncv
    ! local variables
    integer(ki) :: err
    character*64 :: string
    
    count_loop: do 
       read(5,*,iostat=err) string
       if(err < 0) then 
          exit
       elseif(err > 0) then 
          write(0,*) 'count_cv error'
       end if
       if(string(1:1) == '&') ncv = ncv + 1
    end do count_loop

    rewind(5)
    
  end subroutine count_cv
  
  subroutine read_cv(name,list,num)
    ! read a single cv line from input
    implicit none
    character*64, intent(out) :: name
    integer(ki), intent(out) :: list(:)
    integer(ki), intent(out) :: num
    ! local variables
    integer(ki) :: i
    integer(ki) :: err
    character*1 :: symbol
    
    read(5,*,iostat=err) symbol, name
    backspace(5)
    select case(name)
    case('atom_distance')
       read(5,*,iostat=err) symbol,name,list(1),list(2)
       num = 1
    case('atom_angle')
       read(5,*,iostat=err) symbol,name,list(1),list(2),list(3)
       num = 1
    case('atom_dihedral')
       read(5,*,iostat=err) symbol,name,list(1),list(2),list(3),list(4)
       num = 1
    case('ramachandran')
       read(5,*,iostat=err) symbol,name,list(1)
       num = 2
    case('n_hbonds')
       read(5,*,iostat=err) symbol,name,list(1)
       num = 1
    case('line_fit')
       read(5,*,iostat=err) symbol,name,list(1), list(2)
       num = 3
    case('puckering')
       read(5,*,iostat=err) symbol,name,list(1)
       num = 3
    case default
       write(0,*) name, ' is not the list of known cv'
       stop
    end select
     
  end subroutine read_cv
  
end module input
