!-- construct an all-trans structure from primary sequence 

program alltrans
  implicit none
  integer mres,beg_gap
  parameter(mres=5000)
  character*3 :: prsymb(mres),beg
  character*10 :: xor,yor,zor
  real*8, allocatable  :: x(:),y(:),z(:)
  real*8 :: xx,yy,zz
  character*4, allocatable :: atm(:)
  character*3, allocatable :: res(:)
  
  integer  :: i,nres,ires,nmax,ierr

  call  get_command_argument(1,beg)
  call  get_command_argument(2,xor)
  call  get_command_argument(3,yor)
  call  get_command_argument(4,zor)
  if(xor.EQ."") xor="0.0"
  if(yor.EQ."") yor="0.0"
  if(zor.EQ."") zor="0.0"
  if(beg.eq."-h".OR.beg.EQ."") THEN
     write(6,*) "Syntax: "
     write(6,*) "   alltrans gap x y z < sequence_file"
     write(6,*) " "
     write(6,*) "   where sequence_file is a file containing the residue sequence"
     write(6,*) "   e.g."
     write(6,*) "    "
     write(6,*) "  ala "
     write(6,*) "  ala "
     write(6,*) "  ala "
     write(6,*) "  .. "
     write(6,*) "   "
     write(6,*) "   'gap' is the RESID of the last residue before the gap"  
     write(6,*) "   'x y z are the coordinates of the origin of the gap N terminal "
     write(6,*) "   if 'gap' is not given, the C-terminal ends with -COO"  
     STOP
  END if
  read(beg(1:3),'(i3)') beg_gap
  read(xor,*) xx
  read(yor,*) yy
  read(zor,*) zz
  if (beg_gap.ne.0) THEN 
     write(6,*) "REMARK PDBRestore GAP begins  ",beg_gap,xx,yy,zz
  endif 
  do i=1,10000
     if(i.gt.mres) THEN
        write(6,*) " Error: nres out of bound; increase MRES and recompile"
     END IF
     read(5,*,end=10) prsymb(i)
  end do
10 nres=i-1
  nmax=nres*15
  allocate(x(nmax),y(nmax),z(nmax),stat=ierr)   ! allocate coordinate arrays
  allocate(atm(nmax),res(nmax),stat=ierr)      ! allocate res and atm arrays
  ! check for unknown residues   
  do i=1,nres
     if (    (prsymb(i).ne."ala").and.(prsymb(i).ne."arg").&
        &and.(prsymb(i).ne."asn").and.(prsymb(i).ne."asp").&
        &and.(prsymb(i).ne."cys").and.(prsymb(i).ne."gln").&
        &and.(prsymb(i).ne."glu").and.(prsymb(i).ne."his").&
        &and.(prsymb(i).ne."hse").and.(prsymb(i).ne."ile").&
        &and.(prsymb(i).ne."leu").and.(prsymb(i).ne."lys").&
        &and.(prsymb(i).ne."met").and.(prsymb(i).ne."mse").&
        &and.(prsymb(i).ne."phe").and.(prsymb(i).ne."pro").&
        &and.(prsymb(i).ne."ser").and.(prsymb(i).ne."bkb").&
        &and.(prsymb(i).ne."fin").and.(prsymb(i).ne."thr").&
        &and.(prsymb(i).ne."trp").and.(prsymb(i).ne."tyr").&
        &and.(prsymb(i).ne."hsp").and.(prsymb(i).ne."hsd").&
        &and.(prsymb(i).ne."val").and.(prsymb(i).ne."gly")) THEN
        write(101,*) prsymb(i)," --> ala"
        prsymb(i)="ala"
     end if
  end do


  call buildpoly(prsymb,beg_gap,nres,x,y,z,atm,res,nmax)
  ires=beg_gap
  do i=1,nmax
     if(atm(i).EQ."N   ") ires=ires+1  
     write(6,20) i, atm(i),res(i),ires,xx+x(i),yy+y(i),zz+z(i)
20   format("ATOM",i7,2x,A4,A3,I6,4x,3f8.3)
  END DO

! print rotated alltrans about the y-axis  
  ires=beg_gap
  do i=1,nmax
     if(atm(i).EQ."N   ") ires=ires+1
 !   rotate around y    
     write(90,20)  i, atm(i),res(i),ires,xx+z(i),yy+y(i),zz-x(i)
     write(180,20) i, atm(i),res(i),ires,xx-x(i),yy+y(i),zz-z(i)
     write(270,20) i, atm(i),res(i),ires,xx-z(i),yy+y(i),zz+x(i)
 !   rotate around z    
     write(92,20)  i, atm(i),res(i),ires,xx+y(i),yy-x(i),zz+z(i)
     write(272,20) i, atm(i),res(i),ires,xx-y(i),yy+x(i),zz+z(i)
  END DO

  if (beg_gap.ne.0) THEN 
     write(6,*) "REMARK PDBRestore GAP ends  ",ires
  endif 
end program alltrans


subroutine buildpoly(prsymb,beg_gap,nres,xa,ya,za,atm,res,nmax)
  implicit none 
  type residue   ! definition for a structure for RESIDUE
     character*4 :: atom   ! atom type
     real*8 :: x           ! coord
     real*8 :: y            
     real*8 :: z
     integer   natom       ! number of atoms
  end type residue
  type(residue) ala(9)
  type(residue) arg(9)
  type(residue) asn(9)
  type(residue) asp(9)
  type(residue) cys(9)
  type(residue) gln(9)
  type(residue) glu(9)
  type(residue) his(9)
  type(residue) hse(9)
  type(residue) hsd(9)
  type(residue) hsp(9)
  type(residue) ile(9)
  type(residue) leu(9)
  type(residue) lys(9)
  type(residue) met(9)
  type(residue) mse(9)
  type(residue) phe(9)
  type(residue) pro(9)
  type(residue) ser(9)
  type(residue) bkb(5)
  type(residue) fin(9)
  type(residue) thr(9)
  type(residue) trp(9)
  type(residue) tyr(9)
  type(residue) val(9)
  type(residue) gly(4)
  type(residue) tmps(9)
  real*8 xa(*),ya(*),za(*)
  character*3 :: prsymb(*),res(*)
  character*4 :: atm(*)
  integer   nres,i,j,k,natm,ss,ierr,nmax,nn
  integer   beg_gap     ! gap start from here
  real*8 :: dx,dy,ddx,xtt,ytt,ztt,xt,yt,zt 
  DATA dx,dy /3.525, 0.766/
  ! ------- END OF DECLARATIONS----------------------------------------------------
  !   define residue data structures
  arg(1) = residue( 'CG  ' ,    2.218,   2.878,   1.089,6)
  arg(2) = residue( 'CD  ' ,    2.078,   3.816,   2.299,6)
  arg(3) = residue( 'NE  ' ,    3.078,   4.920,   2.199,6)
  arg(4) = residue( 'CZ  ' ,    3.231,   5.901,   3.084,6)
  arg(5) = residue( 'NH1 ' ,    2.517,   6.012,   4.168,6)
  arg(6) = residue( 'NH2 ' ,    4.140,   6.796,   2.858,6)
  asn(1) = residue( 'CG  ' ,   -0.014,   2.661,   1.259,3)
  asn(2) = residue( 'OD1 ' ,   -0.970,   2.404,   1.975,3)
  asn(3) = residue( 'ND2 ' ,   -0.023,   3.767,   0.564,3)
  asp(1) = residue( 'CG  ' ,    2.260,   2.833,   1.224,3)
  asp(2) = residue( 'OD1 ' ,    2.904,   3.067,   0.198,3)
  asp(3) = residue( 'OD2 ' ,    2.334,   3.369,   2.331,3)
  cys(1) = residue( 'SG  ' ,    2.584,   2.858,   1.178,1)
  glu(1) = residue( 'CG  ' ,    1.204,   0.997,   2.516,4)
  glu(2) = residue( 'CD  ' ,    1.039,   1.848,   3.778,4)
  glu(3) = residue( 'OE1 ' ,    1.008,   1.370,   4.904,4)
  glu(4) = residue( 'OE2 ' ,    0.930,   3.183,   3.528,4)
  gln(1) = residue( 'CG  ' ,    2.393,   2.688,   1.344,4)
  gln(2) = residue( 'CD  ' ,    2.434,   3.558,   2.606,4)
  gln(3) = residue( 'OE1 ' ,    3.378,   4.299,   2.831,4)
  gln(4) = residue( 'NE2 ' ,    1.458,   3.495,   3.476,4)
  his(1) = residue( 'CG  ' ,    1.180,   3.184,   0.812,5)
  his(2) = residue( 'ND1 ' ,    1.185,   3.745,  -0.463,5)
  his(3) = residue( 'CD2 ' ,    1.170,   4.161,   1.797,5)
  his(4) = residue( 'CE1 ' ,    1.172,   5.052,  -0.138,5)
  his(5) = residue( 'NE2 ' ,    1.166,   5.385,   1.181,5)
  hse(1) = residue( 'CG  ' ,    1.180,   3.184,   0.812,5)
  hse(2) = residue( 'ND1 ' ,    1.185,   3.745,  -0.463,5)
  hse(3) = residue( 'CD2 ' ,    1.170,   4.161,   1.797,5)
  hse(4) = residue( 'CE1 ' ,    1.172,   5.052,  -0.138,5)
  hse(5) = residue( 'NE2 ' ,    1.166,   5.385,   1.181,5)
  hsd(1) = residue( 'CG  ' ,    1.180,   3.184,   0.812,5)
  hsd(2) = residue( 'ND1 ' ,    1.185,   3.745,  -0.463,5)
  hsd(3) = residue( 'CD2 ' ,    1.170,   4.161,   1.797,5)
  hsd(4) = residue( 'CE1 ' ,    1.172,   5.052,  -0.138,5)
  hsd(5) = residue( 'NE2 ' ,    1.166,   5.385,   1.181,5)
  hsp(1) = residue( 'CG  ' ,    1.180,   3.184,   0.812,5)
  hsp(2) = residue( 'ND1 ' ,    1.185,   3.745,  -0.463,5)
  hsp(3) = residue( 'CD2 ' ,    1.170,   4.161,   1.797,5)
  hsp(4) = residue( 'CE1 ' ,    1.172,   5.052,  -0.138,5)
  hsp(5) = residue( 'NE2 ' ,    1.166,   5.385,   1.181,5)
  ile(1) = residue( 'CG1 ' ,   -0.096,   2.605,   1.220,3)
  ile(2) = residue( 'CG2 ' ,    2.431,   2.650,   1.224,3)
  ile(3) = residue( 'CD1 ' ,   -0.333,   3.304,   2.575,3)
  leu(1) = residue( 'CG  ' ,    0.174,   2.832,   1.506,3)
  leu(2) = residue( 'CD1 ' ,    0.302,   3.176,   2.999,3)
  leu(3) = residue( 'CD2 ' ,    0.373,   4.117,   0.683,3)
  lys(1) = residue( 'CG  ' ,    2.418,   2.658,   1.255,4)
  lys(2) = residue( 'CD  ' ,    2.467,   3.504,   2.535,4)
  lys(3) = residue( 'CE  ' ,    3.781,   4.310,   2.572,4)
  lys(4) = residue( 'NZ  ' ,    3.819,   5.130,   3.816,4)
  met(1) = residue( 'CG  ' ,    0.051,   2.761,   1.160,3)
  met(2) = residue( 'SD  ' ,    0.314,   3.904,   2.527,3)
  met(3) = residue( 'CE  ' ,   -1.302,   4.690,   2.531,3)
  mse(1) = residue( 'CG  ' ,    0.051,   2.761,   1.160,3)
  mse(2) = residue( 'SD  ' ,    0.314,   3.904,   2.527,3)
  mse(3) = residue( 'CE  ' ,   -1.302,   4.690,   2.531,3)
  phe(1) = residue( 'CG  ' ,   -0.007,   2.672,   1.276,6)
  phe(2) = residue( 'CD1 ' ,   -1.178,   2.225,   1.900,6)
  phe(3) = residue( 'CD2 ' ,    0.037,   3.962,   0.742,6)
  phe(4) = residue( 'CE1 ' ,   -2.294,   3.051,   1.973,6)
  phe(5) = residue( 'CE2 ' ,   -1.077,   4.793,   0.825,6)
  phe(6) = residue( 'CZ  ' ,   -2.244,   4.336,   1.437,6)
  pro(1) = residue( 'CG  ' ,    0.460,   0.753,   2.081,2)
  pro(2) = residue( 'CD  ' ,   -0.637,   0.137,   1.207,2)
  ser(1) = residue( 'OG  ' ,    1.290,   0.999,   2.361,1)
  thr(1) = residue( 'OG1 ' ,    0.088,   2.615,   1.055,2)
  thr(2) = residue( 'CG2 ' ,    2.416,   2.624,   1.346,2)
  trp(1) = residue( 'CG  ' ,    0.094,   2.791,   1.143,9)
  trp(2) = residue( 'CD1 ' ,   -1.155,   2.682,   1.790,9)
  trp(3) = residue( 'CD2 ' ,    0.070,   3.998,   0.478,9)
  trp(4) = residue( 'NE1 ' ,   -1.964,   3.809,   1.548,9)
  trp(5) = residue( 'CE2 ' ,   -1.183,   4.609,   0.729,9)
  trp(6) = residue( 'CE3 ' ,    1.026,   4.627,  -0.362,9)
  trp(7) = residue( 'CZ2 ' ,   -1.486,   5.862,   0.153,9)
  trp(8) = residue( 'CZ3 ' ,    0.707,   5.867,  -0.916,9)
  trp(9) = residue( 'CH2 ' ,   -0.530,   6.477,  -0.661,9)
  tyr(1) = residue( 'CG  ' ,    0.050,   2.736,   1.258,7)
  tyr(2) = residue( 'CD1 ' ,    0.086,   3.939,   0.547,7)
  tyr(3) = residue( 'CD2 ' ,   -1.039,   2.459,   2.090,7)
  tyr(4) = residue( 'CE1 ' ,   -0.960,   4.851,   0.664,7)
  tyr(5) = residue( 'CE2 ' ,   -2.083,   3.372,   2.206,7)
  tyr(6) = residue( 'CZ  ' ,   -2.043,   4.567,   1.492,7)
  tyr(7) = residue( 'OH  ' ,   -3.068,   5.463,   1.601,7)
  val(1) = residue( 'CG1 ' ,    0.063,   2.782,   1.087,2)
  val(2) = residue( 'CG2 ' ,    2.484,   2.502,   1.459,2)
  bkb(1) = residue( 'N   ' ,     0.   ,   0.   ,   0. ,    5)
  bkb(2) = residue( 'CA  ' ,     1.186,   0.831,   0.0,    5)
  bkb(3) = residue( 'C   ' ,     2.432,   0.0  ,   0.0,    5)
  bkb(4) = residue( 'O   ' ,     2.432,  -1.23 ,   0.0,    5)
  bkb(5) = residue( 'CB  ' ,     1.186,   1.716,   1.26,   5)
  fin(1) = residue( 'N   ' ,     0.   ,   0.   ,   0. ,    6)
  fin(2) = residue( 'CA  ' ,     1.186,   0.831,   0.0,    6)
  fin(3) = residue( 'C   ' ,     2.432,   0.0  ,   0.0,    6)
  fin(4) = residue( 'O   ' ,     2.432,  -1.23 ,   0.0,    6)
  fin(5) = residue( 'CB  ' ,     1.186,   1.716,   1.26,   6)
  fin(6) = residue( 'OXT ' ,     3.495,   0.616,   0.00,   6)
  gly(1) = residue( 'N   ' ,     0.   ,   0.   ,   0. ,    4)
  gly(2) = residue( 'CA  ' ,     1.186,   0.831,   0.0,    4)
  gly(3) = residue( 'C   ' ,     2.432,   0.0  ,   0.0,    4)
  gly(4) = residue( 'O   ' ,     2.432,  -1.23 ,   0.0,    4)


  ddx=-dx  ! first residue is with ammidic N in origin
  k=0
  do i=1,nres
     ddx=ddx+dx
     ss=0
     if(mod(i,2).EQ.0) THEN 
        ss=1
     END IF
     !      print backbone coordinate 
     if(prsymb(i).ne."gly".and.i.ne.nres) THEN 
        do j=1,5
           k=k+1
           if(ss.EQ.1) THEN  ! rotate around x 
              xtt= bkb(j)%x
              ytt=-bkb(j)%y
              ztt=-bkb(j)%z
           ELSE
              xtt=bkb(j)%x ! do not rotate around x 
              ytt=bkb(j)%y
              ztt=bkb(j)%z
           END IF
           xt=xtt+ddx
           yt=ytt+ss*dy   ! shift only if rotation around x is active
           zt=ztt
!           write(6,20) k, bkb(j)%atom,prsymb(i),i,xt,yt,zt
20         format("ATOM",i7,2x,A4,A3,I6,3x,3f8.3)
           !         print side chain 
           xa(k)=xt
           ya(k)=yt
           za(k)=zt
           res(k)=prsymb(i)
           atm(k)= bkb(j)%atom
        end do
        if(prsymb(i).EQ."arg") natm=arg(1)%natom
        if(prsymb(i).EQ."asn") natm=asn(1)%natom
        if(prsymb(i).EQ."asp") natm=asp(1)%natom
        if(prsymb(i).EQ."cys") natm=cys(1)%natom
        if(prsymb(i).EQ."gln") natm=gln(1)%natom
        if(prsymb(i).EQ."glu") natm=glu(1)%natom
        if(prsymb(i).EQ."his") natm=his(1)%natom
        if(prsymb(i).EQ."hse") natm=hse(1)%natom
        if(prsymb(i).EQ."hsd") natm=hsd(1)%natom
        if(prsymb(i).EQ."hsp") natm=hsp(1)%natom
        if(prsymb(i).EQ."ile") natm=ile(1)%natom
        if(prsymb(i).EQ."leu") natm=leu(1)%natom
        if(prsymb(i).EQ."lys") natm=lys(1)%natom
        if(prsymb(i).EQ."met") natm=met(1)%natom
        if(prsymb(i).EQ."mse") natm=mse(1)%natom
        if(prsymb(i).EQ."phe") natm=phe(1)%natom
        if(prsymb(i).EQ."pro") natm=pro(1)%natom
        if(prsymb(i).EQ."ser") natm=ser(1)%natom
        if(prsymb(i).EQ."thr") natm=thr(1)%natom
        if(prsymb(i).EQ."trp") natm=trp(1)%natom
        if(prsymb(i).EQ."tyr") natm=tyr(1)%natom
        if(prsymb(i).EQ."val") natm=val(1)%natom

        if(prsymb(i).EQ."arg") tmps=arg
        if(prsymb(i).EQ."asn") tmps=asn
        if(prsymb(i).EQ."asp") tmps=asp
        if(prsymb(i).EQ."cys") tmps=cys
        if(prsymb(i).EQ."gln") tmps=gln
        if(prsymb(i).EQ."glu") tmps=glu
        if(prsymb(i).EQ."his") tmps=his
        if(prsymb(i).EQ."hse") tmps=hse
        if(prsymb(i).EQ."hsd") tmps=hsd
        if(prsymb(i).EQ."hsp") tmps=hsp
        if(prsymb(i).EQ."ile") tmps=ile
        if(prsymb(i).EQ."leu") tmps=leu
        if(prsymb(i).EQ."lys") tmps=lys
        if(prsymb(i).EQ."met") tmps=met
        if(prsymb(i).EQ."mse") tmps=mse
        if(prsymb(i).EQ."phe") tmps=phe
        if(prsymb(i).EQ."pro") tmps=pro
        if(prsymb(i).EQ."ser") tmps=ser
        if(prsymb(i).EQ."thr") tmps=thr
        if(prsymb(i).EQ."trp") tmps=trp
        if(prsymb(i).EQ."tyr") tmps=tyr
        if(prsymb(i).EQ."val") tmps=val
        if(prsymb(i).EQ."arg") tmps=arg
        if(prsymb(i).EQ."ala") goto 108
        do j=1,natm
           k=k+1
           if(ss.EQ.1) THEN  ! rotate around x 
              xtt= tmps(j)%x
              ytt=-tmps(j)%y
              ztt=-tmps(j)%z
           ELSE
              xtt= tmps(j)%x ! do not rotate around x 
              ytt= tmps(j)%y
              ztt= tmps(j)%z
           END IF
           xt=xtt+ddx
           yt=ytt+ss*dy   ! shift only if rotation around x is active
           zt=ztt
!           write(6,20) k, tmps(j)%atom,prsymb(i),i,xt,yt,zt
           xa(k)=xt
           ya(k)=yt
           za(k)=zt
           res(k)=prsymb(i)
           atm(k)= tmps(j)%atom
        END do
     ELSEif (prsymb(i).eq."gly".and.i.ne.nres) THEN
        do j=1,4
           k=k+1
           if(ss.EQ.1) THEN  ! rotate around x 
              xtt= gly(j)%x
              ytt=-gly(j)%y
              ztt=-gly(j)%z
           ELSE
              xtt=gly(j)%x ! do not rotate around x 
              ytt=gly(j)%y
              ztt=gly(j)%z
           END IF
           xt=xtt+ddx
           yt=ytt+ss*dy   ! shift only if rotation around x is active
           zt=ztt
!           write(6,20) k, gly(j)%atom,prsymb(i),i,xt,yt,zt
           !         print side chain 
           xa(k)=xt
           ya(k)=yt
           za(k)=zt
           res(k)=prsymb(i)
           atm(k)= gly(j)%atom
        end do
     ELSE
        if(beg_gap.ne.0) THEN
           nn=5
           if(prsymb(i).eq."gly") nn=4
        ELSE
           nn=6
        ENDIF
        do j=1,nn
           if(prsymb(i).eq."gly".and.fin(j)%atom.EQ."CB") goto 188
           k=k+1
           if(ss.EQ.1) THEN  ! rotate around x 
              xtt= fin(j)%x
              ytt=-fin(j)%y
              ztt=-fin(j)%z
           ELSE
              xtt=fin(j)%x ! do not rotate around x 
              ytt=fin(j)%y
              ztt=fin(j)%z
           END IF
           xt=xtt+ddx
           yt=ytt+ss*dy   ! shift only if rotation around x is active
           zt=ztt
!           write(6,20) k, fin(j)%atom,prsymb(i),i,xt,yt,zt
           xa(k)=xt
           ya(k)=yt
           za(k)=zt
           res(k)=prsymb(i)
           atm(k)= fin(j)%atom
188        continue           
        end do
!       print last side chain
        if(prsymb(i).EQ."arg") natm=arg(1)%natom
        if(prsymb(i).EQ."asn") natm=asn(1)%natom
        if(prsymb(i).EQ."asp") natm=asp(1)%natom
        if(prsymb(i).EQ."cys") natm=cys(1)%natom
        if(prsymb(i).EQ."gln") natm=gln(1)%natom
        if(prsymb(i).EQ."glu") natm=glu(1)%natom
        if(prsymb(i).EQ."his") natm=his(1)%natom
        if(prsymb(i).EQ."hse") natm=hse(1)%natom
        if(prsymb(i).EQ."hsd") natm=hsd(1)%natom
        if(prsymb(i).EQ."hsp") natm=hsp(1)%natom
        if(prsymb(i).EQ."ile") natm=ile(1)%natom
        if(prsymb(i).EQ."leu") natm=leu(1)%natom
        if(prsymb(i).EQ."lys") natm=lys(1)%natom
        if(prsymb(i).EQ."met") natm=met(1)%natom
        if(prsymb(i).EQ."mse") natm=mse(1)%natom
        if(prsymb(i).EQ."phe") natm=phe(1)%natom
        if(prsymb(i).EQ."pro") natm=pro(1)%natom
        if(prsymb(i).EQ."ser") natm=ser(1)%natom
        if(prsymb(i).EQ."thr") natm=thr(1)%natom
        if(prsymb(i).EQ."trp") natm=trp(1)%natom
        if(prsymb(i).EQ."tyr") natm=tyr(1)%natom
        if(prsymb(i).EQ."val") natm=val(1)%natom
        if(prsymb(i).EQ."gly") natm=0

        if(prsymb(i).EQ."arg") tmps=arg
        if(prsymb(i).EQ."asn") tmps=asn
        if(prsymb(i).EQ."asp") tmps=asp
        if(prsymb(i).EQ."cys") tmps=cys
        if(prsymb(i).EQ."gln") tmps=gln
        if(prsymb(i).EQ."glu") tmps=glu
        if(prsymb(i).EQ."his") tmps=his
        if(prsymb(i).EQ."hse") tmps=hse
        if(prsymb(i).EQ."hsd") tmps=hsd
        if(prsymb(i).EQ."hsp") tmps=hsp
        if(prsymb(i).EQ."ile") tmps=ile
        if(prsymb(i).EQ."leu") tmps=leu
        if(prsymb(i).EQ."lys") tmps=lys
        if(prsymb(i).EQ."met") tmps=met
        if(prsymb(i).EQ."mse") tmps=mse
        if(prsymb(i).EQ."phe") tmps=phe
        if(prsymb(i).EQ."pro") tmps=pro
        if(prsymb(i).EQ."ser") tmps=ser
        if(prsymb(i).EQ."thr") tmps=thr
        if(prsymb(i).EQ."trp") tmps=trp
        if(prsymb(i).EQ."tyr") tmps=tyr
        if(prsymb(i).EQ."val") tmps=val
        if(prsymb(i).EQ."arg") tmps=arg
        if(prsymb(i).EQ."ala") goto 108
        do j=1,natm
           k=k+1
           if(ss.EQ.1) THEN  ! rotate around x 
              xtt= tmps(j)%x
              ytt=-tmps(j)%y
              ztt=-tmps(j)%z
           ELSE
              xtt= tmps(j)%x ! do not rotate around x 
              ytt= tmps(j)%y
              ztt= tmps(j)%z
           END IF
           xt=xtt+ddx
           yt=ytt+ss*dy   ! shift only if rotation around x is active
           zt=ztt
!           write(6,20) k, tmps(j)%atom,prsymb(i),i,xt,yt,zt
           xa(k)=xt
           ya(k)=yt
           za(k)=zt
           res(k)=prsymb(i)
           atm(k)= tmps(j)%atom
        END do
     ENdif
108  continue
  END DO
  nmax=k
end subroutine buildpoly


