  program qqtest
    implicit none 
! This subroutine implement the qq test for  work distribution   
! (see Krishnamooorthy Handbook of Stat. dist with appl. Taylor-Fracis 2016, page 146)  
    integer i,j,k,nw,npoints, status
    character(len=32) :: arg,workfile
    real*8    ::  frac,t,wm,wm2,swm2,xmin,xmax,range,resol,intg,x,y,eps,errorf,pi,pifact,pmin,pmax
    real*8    ::  sq2,wmax,wmin,work,zm,zm2,r,rxy,sx,sy,a,b,sense,ww
    real*8, allocatable :: wrk(:),p(:),z(:),phi(:)
    
    frac=0.05   ! default value
    pi=dacos(-1.d0)
    pifact =  1/dsqrt(2*pi)
! check args number 
    if(iargc().ne.1.and.iargc().ne.2) THEN 
       write(6,*) 
       write(6,*) "Syntax: "
       write(6,*) "        qq [frac ] workfile"
       write(6,*) "        workfile is the work file" 
       write(6,*) "           frac is an optional arguments:"         
       write(6,*) "           frac -> is the confidence level (e.g. 0.05) " 
       write(6,*) 
       go to 2
    end if

    !   parse arguments (either 1 or 3)
    if(iargc().eq.1) THEN  
       call getarg(1,workfile)  ! only the workfile is given
    else 
       call getarg(1,arg)       ! seedx and botstrap fraction are also given 
       read(arg,*) frac
       call getarg(2,workfile)
    end if

    open(unit=10,file=workfile) 
    nw=0
    do while(status==0) 
       read(10,*,IOSTAT=status) 
       nw=nw+1
    end do
    nw=nw-1
    !   allocate all arrays 
    allocate(wrk(nw),p(nw),z(nw),phi(nw),stat=status) 
    rewind(10)
    wm=0.d0
    wm2=0.d0
    do i=1,nw
       read(10,*) wrk(i)
       wm=wm+wrk(i) 
       wm2=wm2+wrk(i)**2
    end do
    wm=wm/nw
    wm2=wm2/nw
    swm2=wm2-wm**2.
    pmin= pifact*exp(-xmin**2/2)
!   sort real numbers in ascending order 
    do i=1,nw
       do j=i,nw
          if (wrk(i) > wrk(j) )   then
             t=wrk(j)
             wrk(j)=wrk(i)
             wrk(i)=t
          end if
       end do
    end do
    

!   computes the cumulative probabilities on th sorted data
    do j=1,nw
       p(j)=(j-0.5d0 )/dfloat(nw)
    end do
    resol=p(1)/2.d0
    ww = -nw -ww/float(nw)
    xmin=(wrk(1)-wm )/dsqrt(swm2)  ! minimum value of work on a standard normal distribution (0 mean, 1 sigma)  
    xmax=(wrk(nw)-wm )/dsqrt(swm2) ! minimum value of work on a standard normal distribution (0 mean, 1 sigma)  
    range=xmax-xmin
!   compute z(j)
    sq2=1.d0/dsqrt(2.d0)
    npoints=nint(range/resol)
    eps=10.d0/float(npoints)
!   computes z values using the erfc function. The z-value
!   is the abscissa for a normal distribution giving the 

!   cumulative distribution p(j).
!   tabulate complementary error function
    do j=1,nw
       errorf=2*(1.d0-p(j))
       phi(j)=1.d0-0.5*erfc(sq2*(wrk(j)-wm)/dsqrt(swm2))
       if(errorf.gt.erfc(sq2*xmin)) THEN  ! this is done to avoid mssing first points  
          sense=-1.d0 
       else
          sense=1.d0
       ENDIF
       x=xmin
       if(errorf.gt.erfc(sq2*xmin)) THEN  ! this is done to avoid mssing first points  
          sense=-1.d0 
       else
          sense=1.d0
       ENDIF
       do k=1,npoints
          x=x+resol*sense
          if(x.gt.xmin+range) exit
           if(abs(erfc(sq2*x)-errorf).lt.eps) THEN
             z(j)=x
             xmin=x-resol
             exit
          endif
       end do
    end do
    do j=1,nw 
       ww=ww + (2*j-1)*( log(phi(j)) + log(1.d0-phi(nw+1-j)))
    end do
    ww= -nw -ww/nw -1.d0  ! with p(j) the Anderson darling test gives 1.00000 instead of zero 
!   the z-critical value at the level 0.05    
!   the z-critical value correspond to the area for which the null
!   hypothesis is verifies, i.e. to the area comprised between the two 
!   tails for rejection     
    zm=0.d0
    zm2=0.d0
    do i=1,nw
       write(6,'(5f15.6)')  (wrk(i)-wm)/dsqrt(swm2),z(i),p(i),2*(1.d0-p(i)),erfc(sq2*z(i))
       zm=zm+z(i)
       zm2=zm2+z(i)**2.
    end do
!   computes correlation coefficents
    zm=zm/nw
    zm2=zm2/nw
    sx=(wm2-wm**2)**0.5   
    sy=(zm2-zm**2)**0.5
    r=0.d0
    do i=1,nw
       r=r + (wrk(i)-wm)*(z(i)-zm)
    end do
    rxy=r/(sx*sy)/float(nw) 
    a=rxy*sy/sx
    b=zm-a*wm 
    if(ww.lt.0.752) THEN
       write(6,'("# normality test passed --> A^2(Anderson-Darling) =",f10.3 )') ww
    else
       write(6,'("# normality test failed --> A^2(Anderson-Darling) =",f10.3 )') ww
    end if
    write(6,'("#  r,s_q, s, a, b  -- > ", f8.6,4f10.4,f10.5)') rxy,1/a,sqrt(swm2),a,b,ww
2   continue
  end program qqtest
