#! /bin/bash

#
# $0 DIR DCD_FILE DCD_REF 
#    
#    prepare MBAR input files from a REM run

# ----------------------------------------------------------------------
# help: copy first comments block in this file
# ----------------------------------------------------------------------
function help() {
name=`basename "$0"`;
sed -n "s/\$0/$name/;2,/^\$/p" $0; exit
}


# ----------------------------------------------------------------------
# init and defaults   
# ----------------------------------------------------------------------
ORAC_DIR=../..

# ----------------------------------------------------------------------
# command line options
# ----------------------------------------------------------------------
while getopts "n:hqz-" Option
do
  case $Option in
      *     )    help;;   # help: copy first comments block
  esac
done


shift $(($OPTIND - 1))
#  Decrements the argument pointer so it points to next argument.
#  $1 now references the first non option item supplied on the command line
#+ if one exists.

# ----------------------------------------------------------------------
# command line arguments
# ----------------------------------------------------------------------
if [ $# -lt 3 ] ; then help;  fi

REM_DIR=$1
DCD_FILE=$2
DCD_REF=$3

# ----------------------------------------------------------------------
# final parameters setting
# ----------------------------------------------------------------------

# ----------------------------------------------------------------------
# engine
# ----------------------------------------------------------------------

# create a PDB file with all trajectories, and one with only replica=1
for i in   ${REM_DIR}/PAR*; do ${ORAC_DIR}/tools/dcd2pdb/src/dcd2pdb -pdb ${DCD_REF} -dcd $i/${DCD_FILE} ; done  > mbar.pdb
for i in   ${REM_DIR}/PAR*; do ${ORAC_DIR}/tools/dcd2pdb/example/select-replica.sh 1 $i/${DCD_FILE}.rem > frames ; ${ORAC_DIR}/tools/dcd2pdb/src/dcd2pdb -pdb ${DCD_REF} -dcd $i/${DCD_FILE} -f frames ; done > mbar.r01.pdb
rm frames

#create energies file matching pdb file
cat  ${REM_DIR}/PAR*/${DCD_FILE}.rem | awk '{print $2, $3, $4, $5}' > mbar.ene

#  transform REM.set into mbar.parm input for mbar 
cp ${REM_DIR}/PAR0000/REM.set scaling_factors.dat
