#!/bin/bash

SRC=../../src
exe1=INTEL-FFTW-OMP
exe=$SRC/$exe1/orac

if [ $# -ne 3 ];  then  
    echo " Syntax: omp_timing.bash filename level1 level2 "
    echo "         filename -> the orac input file with no OMP header" 
    echo "         leve11   -> NTHREADS for level1 par (N0, INTEGR)    " 
    echo "         level2   -> NTHREADS for level2 par (N1, RECPR)    " 
    exit        
fi
rm ?t_* >/dev/null
for i in  8 4 2 1  ; do
    echo "Test for processors " $i ;
    for j in 8 ;  do
	echo "#&T NTHREADS   "  $i "  CACHELINE  " $j > tmp.in;
	echo "#&T NT-LEVEL1  "  $2 "  CACHELINE  " $j >> tmp.in;
	echo "#&T NT-LEVEL2  "  $3 "  CACHELINE  " $j >> tmp.in;
	cat $1 >> tmp.in; 
	$exe  < tmp.in > $1.$i.out
	echo $i >> 0t_NP
	echo $j >> 1t_NC
	grep "Total elaps"   $1.$i.out  | awk '{print $8}'>>    at_E
	grep "time(cnst"     $1.$i.out  | awk '{print $3}' >>   bt_cn
	grep "time(integr"   $1.$i.out  | awk '{print $3}' >>   bt_int
	grep "time(intra NO" $1.$i.out  | awk '{print $3}' >>   ct_n0
	grep "time(intra N1" $1.$i.out  | awk '{print $3}'>>    dt_n1
	grep "time(inter M"  $1.$i.out  | awk '{print $4}'>>    et_m
	grep "time(inter L"  $1.$i.out  | awk '{print $4}'>>    ft_l
	grep "time(inter H"  $1.$i.out  | awk '{print $4}'>>    gt_h
	grep "time(recpr"    $1.$i.out  | awk '{print $4}' >>   ht_r
	grep "time(updte"    $1.$i.out  | awk '{print $4}'>>    it_u
    done
done
rev=`cat /proc/cpuinfo | grep "model n" | tail -1 | awk '{print $4 $5}'`
echo "     N  Cache  Tot    Cnst     Int     N0      N1      M       L       H       U       R " > TIMES.$1.$2.$3.$exe1.$rev
paste ?t_* | awk '{printf "%5d%5d%8.2f%8.2f%8.2f%8.2f%8.2f%8.2f%8.2f%8.2f%8.2f%8.2f\n",$1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12}' | sort -k 1,1n >>  TIMES.$1.$2.$3.$exe1.$rev

