#!/bin/sh
# example of bash script for gnuplot
# synopsis:
# gplot [file]
# generate and plot a file.eps file through gnuplot
gnuplot << EOF
set terminal postscript eps color enhanced
set output "$1.eps"
set xlabel "r"
set ylabel "theta"
set title "butane isomerization"
set xrange [ 2.6 : 4.4 ]
set yrange [ -180 : 180 ]
set zrange [ -30 : 0 ]
set palette defined (-30 "black",-25 "brown",-20 "red", -15 "orange", -10 "yellow", -5 "green", 0 "blue", 5 "white")
########################
#set pm3d
#splot "$1" using 1:2:3 with pm3d
###########################
#set contour
#set cntrparam levels 10
#set contour base
#set nosurface
#set view 0,0
#splot "$1" using 1:2:3 with lines
###########################
set pm3d at b
set view 0,0
splot "$1" using 1:2:3 with pm3d
EOF

ghostview "$1.eps"

exit