#!/bin/bash
# This script runs using orac non equilibrium driven process for 
# the unfolding of 10-ala. WRK files are stored in the FORWARD dir.     

if ($1="") >&/dev/null; 
then  
   echo " TARGET program not specified; using Default"  ;
   echo "Syntax: forward_trajectories.bash [TARGET]"
   echo "NB. if TARGET is not in the path, full path must be specified in TARGET"
   exit
else TARGET=$1; 
fi

# ntraj is the number of non equlibrium experiments
ntraj=`ls RESTART_B | wc | awk '{print $1}'`
echo $ntraj "starting points found......" 
rm fuffa >& /dev/null
TARGET=$1
if `test -d REVERSE`; then 
    echo "REVERSE directory exists! Files will be overwritten..."
else  
    mkdir REVERSE
fi
###for((i=1; i<=$ntraj; i++)); 
for i in `ls RESTART_B/*.rst`
#
# launch orac program for driven non equilibrium experiments
# using the 3.in Template input file.   
# the starting configuratios  are taken from the RESTART_A dir. 
#
do 
   cp ala10.prmtpg  ala10_B.prmtpg
   f=`basename $i`;
   sed 's/pippo/'$f'/' ./4b.in > tmpb.in;
   (( j++ ));
   $TARGET < tmpb.in > fuffab ;
   grep -i 'bond' WRKb.1  > REVERSE/$j.wrk ;
   echo $j " process done.." `tail -1 REVERSE/$j.wrk`
done 
