#!/bin/bash
# This script runs using orac non equilibrium driven process for 
# the unfolding of 10-ala. WRK files are stored in the FORWARD dir.     

if ($1="") >&/dev/null; 
then  
   echo " TARGET program not specified; using Default"  ;
   echo "Syntax: forward_trajectories.bash [TARGET]"
   echo "NB. if TARGET is not in the path, full path must be specified in TARGET"
   exit
else TARGET=$1; 
fi

# ntraj is the number of non equlibrium experiments
ntraj=`ls RESTART_A | wc | awk '{print $1}'`
echo $ntraj "starting points found......" 
rm fuffa >& /dev/null
TARGET=$1
if `test -d FORWARD`; then 
    echo "FORWARD directory exists! Files will be overwritten..."
else  
    mkdir FORWARD
fi
###for((i=1; i<=$ntraj; i++)); 
for i in `ls RESTART_A/*.rst`
#
# launch orac program for driven non equilibrium experiments
# using the 3.in Template input file.   
# the starting configuratios  are taken from the RESTART_A dir. 
#
#do sed 's/pippo/'$i'.rst/' ./4a.in > tmpa.in;
do 
   cp  ala10.prmtpg  ala10_A.prmtpg 
   f=`basename $i `;
   sed 's/pippo/'$f'/' ./4a.in > tmpa.in;
   (( j++ ));
   $TARGET < tmpa.in > fuffaa ;
   grep -i 'bond' WRKa.1  > FORWARD/$j.wrk ;
   echo $j " process done...." `tail -1 FORWARD/$j.wrk`
done 
