#!/bin/bash
if [ $# -ne 2 ]; then  
    echo      "Syntax:"
    echo      " ./do_all_bash ORAC_OMP_EXE ORAC_OMP_MPI EXE"
    echo      "  "
    echo      "  Example: "
    echo      "./do_all.bash ../../src/INTEL-FFTW-OMP/orac ../../src/INTEL-FFTW-OMP-MPI/orac "
    exit
fi
dep=0
if [ ! -f  $1 ]; then 
    echo $1  " exectuable not found " 
    dep=1
fi
if [ ! -f  $2 ]; then 
    echo $2  " executable not found"
    dep=1
fi
if [ $dep != "0" ] ; then
    exit
fi

ORAC=$1;
ORAC_P=$2;
rm OUT_TEST >& /dev/null
printf "\n%30s" "Doing basics tests "
echo "========= BASICS ==============" >> OUT_TEST
$ORAC < 0b.in | grep "Total    =" >> OUT_TEST ; printf "%1s" "="
$ORAC < 1b.in | grep "Total    =" >> OUT_TEST  ; printf "%1s" "=" 
$ORAC < 2b.in | grep "Total    =" >> OUT_TEST  ; printf "%1s" "=" 
$ORAC < 3b.in | grep "Total    =" >> OUT_TEST  ; printf "%1s" "="
$ORAC < 4b.in | grep "Total    =" >> OUT_TEST  ; printf "%1s" "="
printf "\n%30s" "Doing Jarzynski tests "
echo "========= JARZYNSKI ============" >> OUT_TEST
$ORAC < 1j.in | grep "Total    =" >> OUT_TEST ; tail -2 WRK.ala10 >> OUT_TEST ; printf "%1s" "="
$ORAC < 2j.in | grep "Total    =" >> OUT_TEST ; tail -2 WRK.ala10 >> OUT_TEST ; printf "%1s" "="
$ORAC < 3j.in | grep "Total    =" >> OUT_TEST ; tail -2 WRK.ala10 >> OUT_TEST ; printf "%1s" "="
$ORAC < 4j.in | grep "Total    =" >> OUT_TEST ; tail -4 WRK.ala10 >> OUT_TEST ; printf "%1s" "="
mkdir RESTART_A >& /dev/null						 
mpiexec -n 1 $ORAC_P < 5j.in > out ; grep "Total    =" PAR0001/out0001 >> OUT_TEST;  printf "%1s" "=" 
cp PAR0001/*.prmtpg .
mpiexec -n 4 $ORAC_P < 6j.in > out ;  printf "%1s" "="
for i in PAR*/WRKa.1; do 
    tail -1 $i >> OUT_TEST; 
done;  
printf "\n%30s" "Doing REM tests "
echo "========= REM ============" >> OUT_TEST
mpiexec  -n 4  $ORAC_P  < 1r.in  > out  ; printf "%1s" "=" 
for i in PAR*/REM_DIAGNOSTIC; do 
    tail -2 $i >> OUT_TEST; 
done;  
mpiexec  -n 4  $ORAC_P  < 2r.in  > out ; printf "%1s" "="
for i in PAR*/REM_DIAGNOSTIC; do 
    tail -2 $i >> OUT_TEST; 
done;  
mpiexec  -n 4  $ORAC_P  < 3r.in  > out  ; printf "%1s" "="
for i in PAR*/REM_DIAGNOSTIC; do 
    tail -2 $i >> OUT_TEST; 
done;  
mpiexec  -n 4  $ORAC_P  < 4r.in  > out ; printf "%1s" "="
for i in PAR*/REM_DIAGNOSTIC; do 
    tail -2 $i >> OUT_TEST; 
done;  
mpiexec  -n 4  $ORAC_P  < 5r.in  > out ; printf "%1s" "="
for i in PAR*/REM_DIAGNOSTIC; do 
    tail -2 $i >> OUT_TEST; 
done;  
printf "\n%30s" "Doing ALCHMEY tests "
echo "========= ALCHEMY  ============" >> OUT_TEST

$ORAC < 1a.in | grep "Total    =" >> OUT_TEST ; tail -1 alch1.wrk >> OUT_TEST ; printf "%1s" "="
$ORAC < 2a.in | grep "Total    =" >> OUT_TEST ; tail -1 alch1.wrk >> OUT_TEST ; printf "%1s" "="
mpiexec  -n 1  $ORAC_P  < 3a.in  > out ; printf "%1s" "="
mpiexec  -n 4  $ORAC_P  < 4a.in  > out ; printf "%1s" "="
for i in PAR*/on.wrk; do 
    tail -2 $i >> OUT_TEST; 
done;  
rm -fr PAR*; 
mpiexec  -n 1  $ORAC_P  < 5a.in  > out ; printf "%1s" "="
mpiexec  -n 4  $ORAC_P  < 6a.in  > out ; printf "%1s\n" "="
for i in PAR*/off.wrk; do 
    tail -2 $i >> OUT_TEST; 
done;  

rm -fr *.pdb *.ala* PAR00* tt* *.*prm* INPUT *out *WRK*  *.frq *.rst RESTART_A *.wrk

diff OUT_TEST OUT && echo "tests OK"; 