#!/usr/bin/perl

# reorder pdb file(s) by replica  
#
# syntax: order0.pl [R=<replica-number>] <pdb-file-name>  ...
#    typical use: 'order0.pl PAR*/myout.pdb'
# options:
#    R=<replica-number> : select only one replica, output to STDOUT
#  
# output goes to single-replica files named like "r<replica>_<last-file-basename>"
#   or to STDOUT if R= option is specified

# this tool should be used instead of 'order.sh' when
#   short of disk space, or with a slow I/O 

# 
eval 'exec /usr/bin/perl -S $0 ${1+"$@"}'
    if $running_under_some_shell;
			# this emulates #! processing on NIH machines.
			# (remove #! line above if indigestible)


# default values for vars
$R=0;

# process any FOO=bar switches
eval '$'.$1.'$2;' while $ARGV[0] =~ /^([A-Za-z_0-9]+=)(.*)/ && shift;

# default settings
$[ = 1;			# set array base to 1
$, = ' ';		# set output field separator
$\ = "\n";		# set output record separator


# ----------------------------------------------------------------------
#  read system frames from input stream into %frame{$replica}{$t}
# ----------------------------------------------------------------------

while (<>) {
    @Fld = split(' ', $_, 0);    # split awk-style, discard trailing space

# In PDB trajectories from ORAC, each frame starts with a line like
#   "REMARK   1 Configuration at time step     1550.00"
# or 
#   "REPLICA 25 Temperatures: 300.000 10604.454 513.066 Potential terms: 415.26809 1437.89347 -34836.35596 Time step 39000000.00"
    if (/ime step/) {
	$t = $Fld[$#Fld];     
	$replica = $Fld[2];
	$frame{$replica}{$t}=$_;
    }

# In PDB trajectories from "xyz2pdb", each frame starts with :
#   "REMARK number of atoms:    142"
#   "REMARK simulation time:  21420000.000"
#   "REMARK co matrix      :        29.760       0.000       0.000       0.000      29.760       0.000       0.000       0.000      29.760"
#   "REMARK replica index  :     32"
#   "REMARK REM factors    :         1.000       0.010       0.500"
#   "REMARK REM energies   :       399.965    1899.781  -31700.631"
    elsif (/REMARK number of atoms/) {
	$tmp=$_;
    }
    elsif (/REMARK simulation time/) {
	$t = $Fld[$#Fld];     
	$tmp=$tmp.$_;
    }
    elsif (/REMARK co matrix/) {
	$tmp=$tmp.$_;
    }
    elsif (/REMARK replica index/) {
	$replica = $Fld[$#Fld];     
	$frame{$replica}{$t}=$tmp.$_;
    }


# In PDB trajectories from ORAC and xyz2pdb since r1416, each frame starts with :
#   "REMARK   Time:          100.00 CO matrix:   30.86000   0.00000   0.00000   0.00000  30.86000   0.00000   0.00000   0.00000  30.86000 Ensemble:    2"
    elsif (/REMARK   Time:/) {
	$t = $Fld[3];     
	$replica = $Fld[$#Fld];     
	$frame{$replica}{$t}=$_;
    }


# Atom coordinates: add to appropriate frame
    else {
	$frame{$replica}{$t}=$frame{$replica}{$t}.$_;
    }

}

# ----------------------------------------------------------------------
#  print frames to single-replica files 
#    named like "r<replica>_<last-file-basename>"
#    
# ----------------------------------------------------------------------

use File::Basename;

($filename, $basename) = fileparse($ARGV);  # last file processed

foreach $i (sort {$a <=> $b} keys (%frame)) {
    if ( $R != 0 && $i != $R ) { next };
    if ( $R == 0 ) {
	$newfile = sprintf("r%04d_%s",$i,$filename);
	open(REP, "> $newfile");
    }
    else {
	*REP=*STDOUT;
    }
    for $j (sort {$a <=> $b} keys %{$frame{$i}}) {
	printf REP $frame{$i}{$j};
    }
}


