#! /usr/bin/awk -f
# produce NH3-termini from inner residues ORAC/tpg file.
# Can be used for any force field with standard N-ter and C-ter
BEGIN  {
    if(ff=="charmm") {
     typen="nh1"; typeh="h" ; typeca="ca";   typeha="ha"  #charmm types
    } 
    if(ff=="opls") {
     typen="n238"; typeh="h241" ; typeca="c224";          #opls types
    }
}
{ 
    if($1=="n" && $2==typen) {
	if(ff=="charmm") {
	    print "   n    nh3   -0.30"    #charmm36 standard
	    print "   ht1  hc    0.33"
	    print "   ht2  hc    0.33"
	    print "   ht3  hc    0.33"
	    print "group"
	    print "   ca   ct1   0.21"
	    print "   ha   hb1   0.10"
	}
	if(ff=="opls") {
                                          #    OPLS below 
	    print "   n    n287   -0.300"
	    print "   ht1  h290    0.330"
	    print "   ht2  h290    0.330"
	    print "   ht3  h290    0.330"
	    print "group"
	    print "   ca   C293    0.250"
	}
    } 
    else if( $1=="hn" && $2 ==typeh) {
	i++
    }
    else if( $1=="ca" && $2 ==typeca) {
	i++
    }
    else if( $1=="ha" && $2 ==typeha) {   
	if(ff=="charmm") {
	    i++;               
	}
	if(ff=="olps") {
	    print;               
	}
            
    }
    else if( $1=="termatom") {
	print "termatom * c"
    }
    else if( $1=="RESIDUE") {
	print "RESIDUE "$2"-h"
    }
    else if( $4=="-c" || $8=="-c" ) {    # fix torsion section
	i++
    }
    else if( $5=="-c" || $9=="-c" ) {
	i++
    }
    else if( $3=="-c" || $7=="-c" ) {
	i++
    }
    else if( $2=="-c" || $6=="-c" ) {
	i++
    }
    else if ($1=="n" && $2 =="hn" ) {                   # fix bonds section 
	print "   n  ht1  n  ht2  n  ht3 "
    }
    else if ($1=="hn" && $2 =="n" ) {
	print "   n  ht1  n  ht2  n  ht3 "
    }
    else if ($3=="n" && $4=="hn" ) {
	print "   n  ht1  n  ht2  n  ht3 "
    }
    else if ($4=="n" && $3=="hn" ) {
	print "   n  ht1  n  ht2  n  ht3 "
    }
    else if ($5=="n" && $6=="hn" ) {
	print "   n  ht1  n  ht2  n  ht3 "
    }
    else if ($6=="n" && $5=="hn" ) {
	print "   n  ht1  n  ht2  n  ht3 "
    }
    else {print}
}


