      program test_zero_w_save
C
C  test compiler option "zero" when used together with option "save"
c
C  Lines marked with "C>" are code corresponding to these options
C     (only with respect to x,y) 

      implicit none
      real v
C>      data v /0./
      character*80 command

      call sub1(v)
      call sub1(v)
      print*, " ( y should be = 4.000 on previous line ) "
      stop 
      end

      subroutine sub1(x)
      implicit none 
      real x, y
      integer i
C>      data y /0./
C>      save y

C the value of y is saved between successive calls to this subroutine
C when compiler options "initialize to zero" and "save local variables"
C are used, e.g. "ifort -save -zero" ; "xlf -qsave -qinitauto" ;
c "g95 -fstatic -fzero"

C GFORTRAN BUG: (4.2 < gfortran < 4.5) 
C with "gfortran -fno-automatic -finit-local-zero" (gfor > 4.2), the
C value of y is NOT saved, but reset to 0, between successive calls to
C this subroutine. As opposed to y, variable x (which is a dummy
C argument to main program's "v") is saved.
C  [http://gcc.gnu.org/bugzilla/show_bug.cgi?id=42267] "when using both
C  flags, the variables are initialized on every function call."

      print*, "sub1:ENTER: x,y=",x,y
      do i =1,2
        x=x+1.
        y=y+1.
        print*, "sub1: after cycle n.",i,": x,y=",x,y      
      end do

      return
      end

